/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.params.ElGamalKeyGenerationParameters;
import org.bouncycastle.crypto.params.ElGamalParameters;
import org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import org.bouncycastle.crypto.params.ElGamalPublicKeyParameters;

public class ElGamalKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private ElGamalKeyGenerationParameters param;

    public AsymmetricCipherKeyPair generateKeyPair() {
        int n = this.param.getStrength() - 1;
        ElGamalParameters elGamalParameters = this.param.getParameters();
        BigInteger bigInteger = elGamalParameters.getP();
        BigInteger bigInteger2 = elGamalParameters.getG();
        BigInteger bigInteger3 = new BigInteger(n, this.param.getRandom());
        BigInteger bigInteger4 = bigInteger2.modPow(bigInteger3, bigInteger);
        return new AsymmetricCipherKeyPair(new ElGamalPublicKeyParameters(bigInteger4, elGamalParameters), new ElGamalPrivateKeyParameters(bigInteger3, elGamalParameters));
    }

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (ElGamalKeyGenerationParameters)keyGenerationParameters;
    }
}

