/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.cert;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.cert.CRL;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.cert.CRLSelector;

public class X509CRLSelector
implements CRLSelector {
    private Set issuerNames = null;
    private Set issuerNamesX509 = null;
    private BigInteger minCRL = null;
    private BigInteger maxCRL = null;
    private Date dateAndTime = null;
    private X509Certificate certChecking = null;

    public void addIssuerName(String string) throws IOException {
        X509Name x509Name;
        if (this.issuerNames == null) {
            this.issuerNames = new HashSet();
            this.issuerNamesX509 = new HashSet();
        }
        try {
            x509Name = new X509Name(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(illegalArgumentException.getMessage());
        }
        this.issuerNamesX509.add(x509Name);
        this.issuerNames.add(new String(string));
    }

    public void addIssuerName(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream;
        DERInputStream dERInputStream;
        DERObject dERObject;
        if (this.issuerNames == null) {
            this.issuerNames = new HashSet();
            this.issuerNamesX509 = new HashSet();
        }
        if ((dERObject = (dERInputStream = new DERInputStream(byteArrayInputStream = new ByteArrayInputStream(byArray))).readObject()) == null || !(dERObject instanceof ASN1Sequence)) {
            throw new IOException("parsing error");
        }
        this.issuerNamesX509.add(new X509Name((ASN1Sequence)dERObject));
        this.issuerNames.add(byArray.clone());
    }

    public Object clone() {
        try {
            X509CRLSelector x509CRLSelector = (X509CRLSelector)super.clone();
            if (this.issuerNames != null) {
                x509CRLSelector.issuerNames = new HashSet();
                Iterator iterator = this.issuerNames.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (e instanceof byte[]) {
                        x509CRLSelector.issuerNames.add(((byte[])e).clone());
                        continue;
                    }
                    x509CRLSelector.issuerNames.add(e);
                }
                x509CRLSelector.issuerNamesX509 = new HashSet(this.issuerNamesX509);
            }
            return x509CRLSelector;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof X509CRLSelector)) {
            return false;
        }
        X509CRLSelector x509CRLSelector = (X509CRLSelector)object;
        if (!this.equals(this.dateAndTime, x509CRLSelector.dateAndTime)) {
            return false;
        }
        if (!this.equals(this.minCRL, x509CRLSelector.minCRL)) {
            return false;
        }
        if (!this.equals(this.maxCRL, x509CRLSelector.maxCRL)) {
            return false;
        }
        if (!this.equals(this.issuerNamesX509, x509CRLSelector.issuerNamesX509)) {
            return false;
        }
        return this.equals(this.certChecking, x509CRLSelector.certChecking);
    }

    private boolean equals(Object object, Object object2) {
        return object == null ? object2 != null : !object.equals(object2);
    }

    public X509Certificate getCertificateChecking() {
        return this.certChecking;
    }

    public Date getDateAndTime() {
        if (this.dateAndTime == null) {
            return null;
        }
        return new Date(this.dateAndTime.getTime());
    }

    public Collection getIssuerNames() {
        if (this.issuerNames == null) {
            return null;
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        Iterator iterator = this.issuerNames.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof String) {
                hashSet.add(new String((String)e));
                continue;
            }
            if (!(e instanceof byte[])) continue;
            hashSet.add(((byte[])e).clone());
        }
        return hashSet;
    }

    public BigInteger getMaxCRL() {
        return this.maxCRL;
    }

    public BigInteger getMinCRL() {
        return this.minCRL;
    }

    /*
     * Unable to fully structure code
     */
    public boolean match(CRL var1_1) {
        block16: {
            block17: {
                if (!(var1_1 instanceof X509CRL)) {
                    return false;
                }
                var2_2 = (X509CRL)var1_1;
                if (this.issuerNamesX509 == null) break block17;
                var4_3 = this.issuerNamesX509.iterator();
                var3_4 = false;
                var5_5 = null;
                try {
                    var5_5 = X509Name.getInstance(var2_2.getIssuerDN());
                    if (true) ** GOTO lbl18
                }
                catch (IllegalArgumentException var6_6) {
                    var6_6.printStackTrace();
                    return false;
                }
                do {
                    if (!var5_5.equals(var4_3.next(), true)) continue;
                    var3_4 = true;
                    break;
lbl18:
                    // 2 sources

                } while (var4_3.hasNext());
                if (!var3_4) {
                    return false;
                }
            }
            if ((var4_3 = (Object)var2_2.getExtensionValue(X509Extensions.CRLNumber.getId())) != null) {
                try {
                    var5_5 = new ByteArrayInputStream((byte[])var4_3);
                    var6_7 = new DERInputStream((InputStream)var5_5);
                    var5_5 = new ByteArrayInputStream(((ASN1OctetString)var6_7.readObject()).getOctets());
                    var6_7 = new DERInputStream((InputStream)var5_5);
                    var7_8 = ((DERInteger)var6_7.readObject()).getPositiveValue();
                    if (this.minCRL != null && this.minCRL.compareTo(var7_8) > 0) {
                        return false;
                    }
                    if (this.maxCRL != null && this.maxCRL.compareTo(var7_8) < 0) {
                        return false;
                    }
                    break block16;
                }
                catch (IOException v0) {
                    return false;
                }
            }
            if (this.minCRL != null || this.maxCRL != null) {
                return false;
            }
        }
        if (this.dateAndTime != null) {
            var5_5 = var2_2.getThisUpdate();
            if (var5_5 == null) {
                return false;
            }
            if (this.dateAndTime.before((Date)var5_5)) {
                return false;
            }
            var5_5 = var2_2.getNextUpdate();
            if (var5_5 == null) {
                return false;
            }
            if (!this.dateAndTime.before((Date)var5_5)) {
                return false;
            }
        }
        return true;
    }

    public void setCertificateChecking(X509Certificate x509Certificate) {
        this.certChecking = x509Certificate;
    }

    public void setDateAndTime(Date date) {
        this.dateAndTime = date == null ? null : new Date(date.getTime());
    }

    public void setIssuerNames(Collection collection) throws IOException {
        if (collection == null || collection.isEmpty()) {
            this.issuerNames = null;
            this.issuerNamesX509 = null;
        } else {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof String) {
                    this.addIssuerName((String)e);
                    continue;
                }
                if (e instanceof byte[]) {
                    this.addIssuerName((byte[])e);
                    continue;
                }
                throw new IOException("name not byte[]or String: " + e.toString());
            }
        }
    }

    public void setMaxCRLNumber(BigInteger bigInteger) {
        this.maxCRL = bigInteger;
    }

    public void setMinCRLNumber(BigInteger bigInteger) {
        this.minCRL = bigInteger;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("X509CRLSelector: [\n");
        if (this.issuerNamesX509 != null) {
            stringBuffer.append("  IssuerNames:\n");
            Iterator iterator = this.issuerNamesX509.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("    " + iterator.next().toString() + "\n");
            }
        }
        if (this.minCRL != null) {
            stringBuffer.append("  minCRLNumber: " + this.minCRL + "\n");
        }
        if (this.maxCRL != null) {
            stringBuffer.append("  maxCRLNumber: " + this.maxCRL + "\n");
        }
        if (this.dateAndTime != null) {
            stringBuffer.append("  dateAndTime: " + this.dateAndTime + "\n");
        }
        if (this.certChecking != null) {
            stringBuffer.append("  Certificate being checked: " + this.certChecking + "\n");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

