/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.AESWrapEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.test.BlockCipherMonteCarloTest;
import org.bouncycastle.crypto.test.BlockCipherVectorTest;
import org.bouncycastle.crypto.test.CipherTest;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class AESTest
extends CipherTest {
    static Test[] tests = new Test[]{new BlockCipherVectorTest(0, (BlockCipher)new AESEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"80000000000000000000000000000000")), "00000000000000000000000000000000", "0EDD33D3C621E546455BD8BA1418BEC8"), new BlockCipherVectorTest(1, (BlockCipher)new AESEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"00000000000000000000000000000080")), "00000000000000000000000000000000", "172AEAB3D507678ECAF455C12587ADB7"), new BlockCipherMonteCarloTest(2, 10000, (BlockCipher)new AESEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"00000000000000000000000000000000")), "00000000000000000000000000000000", "C34C052CC0DA8D73451AFE5F03BE297F"), new BlockCipherMonteCarloTest(3, 10000, (BlockCipher)new AESEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"5F060D3716B345C253F6749ABAC10917")), "355F697E8B868B65B25A04E18D782AFA", "ACC863637868E3E068D2FD6E3508454A"), new BlockCipherVectorTest(4, (BlockCipher)new AESEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"000000000000000000000000000000000000000000000000")), "80000000000000000000000000000000", "6CD02513E8D4DC986B4AFE087A60BD0C"), new BlockCipherMonteCarloTest(5, 10000, (BlockCipher)new AESEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"AAFE47EE82411A2BF3F6752AE8D7831138F041560631B114")), "F3F6752AE8D7831138F041560631B114", "77BA00ED5412DFF27C8ED91F3C376172"), new BlockCipherVectorTest(6, (BlockCipher)new AESEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"0000000000000000000000000000000000000000000000000000000000000000")), "80000000000000000000000000000000", "DDC6BF790C15760D8D9AEB6F9A75FD4E"), new BlockCipherMonteCarloTest(7, 10000, (BlockCipher)new AESEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"28E79E2AFC5F7745FCCABE2F6257C2EF4C4EDFB37324814ED4137C288711A386")), "C737317FE0846F132B23C8C2A672CE22", "E58B82BFBA53C0040DC610C642121168"), new BlockCipherVectorTest(8, (BlockCipher)new AESEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"80000000000000000000000000000000")), "00000000000000000000000000000000", "0EDD33D3C621E546455BD8BA1418BEC8"), new BlockCipherVectorTest(9, (BlockCipher)new AESEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"00000000000000000000000000000080")), "00000000000000000000000000000000", "172AEAB3D507678ECAF455C12587ADB7"), new BlockCipherMonteCarloTest(10, 10000, (BlockCipher)new AESEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"00000000000000000000000000000000")), "00000000000000000000000000000000", "C34C052CC0DA8D73451AFE5F03BE297F"), new BlockCipherMonteCarloTest(11, 10000, (BlockCipher)new AESEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"5F060D3716B345C253F6749ABAC10917")), "355F697E8B868B65B25A04E18D782AFA", "ACC863637868E3E068D2FD6E3508454A"), new BlockCipherVectorTest(12, (BlockCipher)new AESEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"000000000000000000000000000000000000000000000000")), "80000000000000000000000000000000", "6CD02513E8D4DC986B4AFE087A60BD0C"), new BlockCipherMonteCarloTest(13, 10000, (BlockCipher)new AESEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"AAFE47EE82411A2BF3F6752AE8D7831138F041560631B114")), "F3F6752AE8D7831138F041560631B114", "77BA00ED5412DFF27C8ED91F3C376172"), new BlockCipherVectorTest(14, (BlockCipher)new AESEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"0000000000000000000000000000000000000000000000000000000000000000")), "80000000000000000000000000000000", "DDC6BF790C15760D8D9AEB6F9A75FD4E"), new BlockCipherMonteCarloTest(15, 10000, (BlockCipher)new AESEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"28E79E2AFC5F7745FCCABE2F6257C2EF4C4EDFB37324814ED4137C288711A386")), "C737317FE0846F132B23C8C2A672CE22", "E58B82BFBA53C0040DC610C642121168"), new BlockCipherVectorTest(16, (BlockCipher)new AESEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"80000000000000000000000000000000")), "00000000000000000000000000000000", "0EDD33D3C621E546455BD8BA1418BEC8"), new BlockCipherVectorTest(17, (BlockCipher)new AESEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"00000000000000000000000000000080")), "00000000000000000000000000000000", "172AEAB3D507678ECAF455C12587ADB7"), new BlockCipherMonteCarloTest(18, 10000, (BlockCipher)new AESEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"00000000000000000000000000000000")), "00000000000000000000000000000000", "C34C052CC0DA8D73451AFE5F03BE297F"), new BlockCipherMonteCarloTest(19, 10000, (BlockCipher)new AESEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"5F060D3716B345C253F6749ABAC10917")), "355F697E8B868B65B25A04E18D782AFA", "ACC863637868E3E068D2FD6E3508454A"), new BlockCipherVectorTest(20, (BlockCipher)new AESEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"000000000000000000000000000000000000000000000000")), "80000000000000000000000000000000", "6CD02513E8D4DC986B4AFE087A60BD0C"), new BlockCipherMonteCarloTest(21, 10000, (BlockCipher)new AESEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"AAFE47EE82411A2BF3F6752AE8D7831138F041560631B114")), "F3F6752AE8D7831138F041560631B114", "77BA00ED5412DFF27C8ED91F3C376172"), new BlockCipherVectorTest(22, (BlockCipher)new AESEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"0000000000000000000000000000000000000000000000000000000000000000")), "80000000000000000000000000000000", "DDC6BF790C15760D8D9AEB6F9A75FD4E"), new BlockCipherMonteCarloTest(23, 10000, (BlockCipher)new AESEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"28E79E2AFC5F7745FCCABE2F6257C2EF4C4EDFB37324814ED4137C288711A386")), "C737317FE0846F132B23C8C2A672CE22", "E58B82BFBA53C0040DC610C642121168")};

    AESTest() {
        super(tests);
    }

    public String getName() {
        return "AES";
    }

    private boolean isEqualTo(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n != byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        AESTest aESTest = new AESTest();
        TestResult testResult = aESTest.perform();
        System.out.println(testResult);
    }

    public TestResult perform() {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        byte[] byArray4;
        byte[] byArray5;
        byte[] byArray6;
        byte[] byArray7;
        byte[] byArray8;
        byte[] byArray9;
        byte[] byArray10;
        byte[] byArray11;
        byte[] byArray12;
        TestResult testResult = super.perform();
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        byte[] byArray13 = Hex.decode((String)"000102030405060708090a0b0c0d0e0f");
        testResult = this.wrapTest(1, byArray13, byArray12 = Hex.decode((String)"00112233445566778899aabbccddeeff"), byArray11 = Hex.decode((String)"1fa68b0a8112b447aef34bd8fb5a7b829d3e862371d2cfe5"));
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        byte[] byArray14 = Hex.decode((String)"000102030405060708090a0b0c0d0e0f1011121314151617");
        testResult = this.wrapTest(2, byArray14, byArray10 = Hex.decode((String)"00112233445566778899aabbccddeeff"), byArray9 = Hex.decode((String)"96778b25ae6ca435f92b5b97c050aed2468ab8a17ad84e5d"));
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        byte[] byArray15 = Hex.decode((String)"000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f");
        testResult = this.wrapTest(3, byArray15, byArray8 = Hex.decode((String)"00112233445566778899aabbccddeeff"), byArray7 = Hex.decode((String)"64e8c3f9ce0f5ba263e9777905818a2a93c8191e7d6e8ae7"));
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        byte[] byArray16 = Hex.decode((String)"000102030405060708090a0b0c0d0e0f1011121314151617");
        testResult = this.wrapTest(4, byArray16, byArray6 = Hex.decode((String)"00112233445566778899aabbccddeeff0001020304050607"), byArray5 = Hex.decode((String)"031d33264e15d33268f24ec260743edce1c6c7ddee725a936ba814915c6762d2"));
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        byte[] byArray17 = Hex.decode((String)"000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f");
        testResult = this.wrapTest(5, byArray17, byArray4 = Hex.decode((String)"00112233445566778899aabbccddeeff0001020304050607"), byArray3 = Hex.decode((String)"a8f9bc1612c68b3ff6e6f4fbe30e71e4769c8b80a32cb8958cd5d17d6b254da1"));
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        byte[] byArray18 = Hex.decode((String)"000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f");
        testResult = this.wrapTest(6, byArray18, byArray2 = Hex.decode((String)"00112233445566778899aabbccddeeff000102030405060708090a0b0c0d0e0f"), byArray = Hex.decode((String)"28c9f404c4b810f4cbccb35cfb87f8263f5786e2d80ed326cbc7f0e71a99f43bfb988b9b7a02dd21"));
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
    }

    private TestResult wrapTest(int n, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4;
        AESWrapEngine aESWrapEngine = new AESWrapEngine();
        aESWrapEngine.init(true, (CipherParameters)new KeyParameter(byArray));
        try {
            byArray4 = aESWrapEngine.wrap(byArray2, 0, byArray2.length);
            if (!this.isEqualTo(byArray4, byArray3)) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": failed wrap test " + n + " expected " + new String(Hex.encode((byte[])byArray3)) + " got " + new String(Hex.encode((byte[])byArray4)));
            }
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": failed wrap test exception " + exception.toString());
        }
        aESWrapEngine.init(false, (CipherParameters)new KeyParameter(byArray));
        try {
            byArray4 = aESWrapEngine.unwrap(byArray3, 0, byArray3.length);
            if (!this.isEqualTo(byArray4, byArray2)) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": failed unwrap test " + n + " expected " + new String(Hex.encode((byte[])byArray2)) + " got " + new String(Hex.encode((byte[])byArray4)));
            }
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": failed unwrap test exception " + exception.toString());
        }
        return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
    }
}

