/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.digests.MD2Digest;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class MD2DigestTest
implements Test {
    private static String testVec1 = "";
    private static String resVec1 = "8350e5a3e24c153df2275c9f80692773";
    private static String testVec2 = "61";
    private static String resVec2 = "32ec01ec4a6dac72c0ab96fb34c0b5d1";
    private static String testVec3 = "616263";
    private static String resVec3 = "da853b0d3f88d99b30283a69e6ded6bb";
    private static String testVec4 = "6d65737361676520646967657374";
    private static String resVec4 = "ab4f496bfb2a530b219ff33031fe06b0";
    private static String testVec5 = "6162636465666768696a6b6c6d6e6f707172737475767778797a";
    private static String resVec5 = "4e8ddff3650292ab5a4108c3aa47940b";
    private static String testVec6 = "4142434445464748494a4b4c4d4e4f505152535455565758595a6162636465666768696a6b6c6d6e6f707172737475767778797a30313233343536373839";
    private static String resVec6 = "da33def2a42df13975352846c30338cd";
    private static String testVec7 = "3132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930";
    private static String resVec7 = "d5976f79d83d3a0dc9806c3c66f3efd8";

    public String getName() {
        return "MD2";
    }

    public static void main(String[] stringArray) {
        MD2DigestTest mD2DigestTest = new MD2DigestTest();
        TestResult testResult = mD2DigestTest.perform();
        System.out.println(testResult);
    }

    public TestResult perform() {
        MD2Digest mD2Digest = new MD2Digest();
        byte[] byArray = new byte[mD2Digest.getDigestSize()];
        byte[] byArray2 = Hex.decode((String)testVec1);
        mD2Digest.update(byArray2, 0, byArray2.length);
        mD2Digest.doFinal(byArray, 0);
        String string = new String(Hex.encode((byte[])byArray));
        if (!resVec1.equals(string)) {
            return new SimpleTestResult(false, "MD2 failing standard vector test 1" + System.getProperty("line.separator") + "    expected: " + resVec1 + System.getProperty("line.separator") + "    got     : " + string);
        }
        byArray2 = Hex.decode((String)testVec2);
        mD2Digest.update(byArray2, 0, byArray2.length);
        mD2Digest.doFinal(byArray, 0);
        string = new String(Hex.encode((byte[])byArray));
        if (!resVec2.equals(string)) {
            return new SimpleTestResult(false, "MD2 failing standard vector test 2" + System.getProperty("line.separator") + "    expected: " + resVec2 + System.getProperty("line.separator") + "    got     : " + string);
        }
        byArray2 = Hex.decode((String)testVec3);
        mD2Digest.update(byArray2, 0, byArray2.length);
        mD2Digest.doFinal(byArray, 0);
        string = new String(Hex.encode((byte[])byArray));
        if (!resVec3.equals(string)) {
            return new SimpleTestResult(false, "MD2 failing standard vector test 3" + System.getProperty("line.separator") + "    expected: " + resVec3 + System.getProperty("line.separator") + "    got     : " + string);
        }
        byArray2 = Hex.decode((String)testVec4);
        mD2Digest.update(byArray2, 0, byArray2.length);
        mD2Digest.doFinal(byArray, 0);
        string = new String(Hex.encode((byte[])byArray));
        if (!resVec4.equals(string)) {
            return new SimpleTestResult(false, "MD2 failing standard vector test 4" + System.getProperty("line.separator") + "    expected: " + resVec4 + System.getProperty("line.separator") + "    got     : " + string);
        }
        byArray2 = Hex.decode((String)testVec5);
        mD2Digest.update(byArray2, 0, byArray2.length);
        mD2Digest.doFinal(byArray, 0);
        string = new String(Hex.encode((byte[])byArray));
        if (!resVec5.equals(string)) {
            return new SimpleTestResult(false, "MD2 failing standard vector test 5" + System.getProperty("line.separator") + "    expected: " + resVec5 + System.getProperty("line.separator") + "    got     : " + string);
        }
        byArray2 = Hex.decode((String)testVec6);
        mD2Digest.update(byArray2, 0, byArray2.length);
        mD2Digest.doFinal(byArray, 0);
        string = new String(Hex.encode((byte[])byArray));
        if (!resVec6.equals(string)) {
            return new SimpleTestResult(false, "MD2 failing standard vector test 6" + System.getProperty("line.separator") + "    expected: " + resVec6 + System.getProperty("line.separator") + "    got     : " + string);
        }
        byArray2 = Hex.decode((String)testVec7);
        mD2Digest.update(byArray2, 0, byArray2.length);
        mD2Digest.doFinal(byArray, 0);
        string = new String(Hex.encode((byte[])byArray));
        if (!resVec7.equals(string)) {
            return new SimpleTestResult(false, "MD2 failing standard vector test 7" + System.getProperty("line.separator") + "    expected: " + resVec7 + System.getProperty("line.separator") + "    got     : " + string);
        }
        return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
    }
}

