/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.KeyAgreement;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class NamedCurveTest
implements Test {
    private String name;

    NamedCurveTest() {
        this("prime192v1");
    }

    NamedCurveTest(String string) {
        this.name = string;
    }

    public String getName() {
        return "NamedCurve";
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        NamedCurveTest namedCurveTest = stringArray.length == 0 ? new NamedCurveTest() : new NamedCurveTest(stringArray[0]);
        TestResult testResult = namedCurveTest.perform();
        System.out.println(testResult.toString());
    }

    public TestResult perform() {
        try {
            X509EncodedKeySpec x509EncodedKeySpec;
            ECNamedCurveParameterSpec eCNamedCurveParameterSpec = ECNamedCurveTable.getParameterSpec((String)this.name);
            if (eCNamedCurveParameterSpec == null) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + " no curve for " + this.name + " found.");
            }
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECDH", "BC");
            keyPairGenerator.initialize((AlgorithmParameterSpec)eCNamedCurveParameterSpec, new SecureRandom());
            KeyPair keyPair = ((KeyPairGeneratorSpi)keyPairGenerator).generateKeyPair();
            KeyAgreement keyAgreement = KeyAgreement.getInstance("ECDHC", "BC");
            keyAgreement.init(keyPair.getPrivate());
            KeyPair keyPair2 = ((KeyPairGeneratorSpi)keyPairGenerator).generateKeyPair();
            KeyAgreement keyAgreement2 = KeyAgreement.getInstance("ECDHC", "BC");
            keyAgreement2.init(keyPair2.getPrivate());
            keyAgreement.doPhase(keyPair2.getPublic(), true);
            keyAgreement2.doPhase(keyPair.getPublic(), true);
            BigInteger bigInteger = new BigInteger(keyAgreement.generateSecret());
            BigInteger bigInteger2 = new BigInteger(keyAgreement2.generateSecret());
            if (!bigInteger.equals(bigInteger2)) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + " 2-way test failed");
            }
            byte[] byArray = keyPair.getPublic().getEncoded();
            KeyFactory keyFactory = KeyFactory.getInstance("ECDH", "BC");
            ECPublicKey eCPublicKey = (ECPublicKey)keyFactory.generatePublic(x509EncodedKeySpec = new X509EncodedKeySpec(byArray));
            if (!eCPublicKey.getQ().equals((Object)((ECPublicKey)keyPair.getPublic()).getQ())) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": public key encoding (Q test) failed");
            }
            if (!(eCPublicKey.getParams() instanceof ECNamedCurveParameterSpec)) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": public key encoding not named curve");
            }
            byte[] byArray2 = keyPair.getPrivate().getEncoded();
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray2);
            ECPrivateKey eCPrivateKey = (ECPrivateKey)keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            if (!eCPrivateKey.getD().equals(((ECPrivateKey)keyPair.getPrivate()).getD())) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": private key encoding (D test) failed");
            }
            if (!(eCPrivateKey.getParams() instanceof ECNamedCurveParameterSpec)) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": private key encoding not named curve");
            }
            if (!((ECNamedCurveParameterSpec)eCPrivateKey.getParams()).getName().equals(this.name)) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": private key encoding wrong named curve");
            }
            return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": exception - " + exception.toString());
        }
    }
}

