/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.agreement.ECDHCBasicAgreement;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class ECTest
implements Test {
    Test[] tests = new Test[]{new ECDSA192bitPrime(), new ECDSA239bitPrime(), new ECDSAKeyGenTest(), new ECBasicAgreementTest()};

    public String getName() {
        return "EC";
    }

    public TestResult perform() {
        int n = 0;
        while (n != this.tests.length) {
            TestResult testResult = this.tests[n].perform();
            if (!testResult.isSuccessful()) {
                return testResult;
            }
            ++n;
        }
        return new SimpleTestResult(true, "EC: Okay");
    }

    public static void main(String[] stringArray) {
        ECTest eCTest = new ECTest();
        TestResult testResult = eCTest.perform();
        System.out.println(testResult);
    }

    private class ECBasicAgreementTest
    implements Test {
        private ECBasicAgreementTest() {
        }

        public String getName() {
            return "EC basic agreement test";
        }

        public TestResult perform() {
            SecureRandom secureRandom = new SecureRandom();
            ECCurve.Fp fp = new ECCurve.Fp(new BigInteger("883423532389192164791648750360308885314476597252960362792450860609699839"), new BigInteger("7fffffffffffffffffffffff7fffffffffff8000000000007ffffffffffc", 16), new BigInteger("6b016c3bdcf18941d0d654921475ca71a9db2fb27d1d37796185c2942c0a", 16));
            ECDomainParameters eCDomainParameters = new ECDomainParameters((ECCurve)fp, fp.decodePoint(Hex.decode((String)"020ffa963cdca8816ccc33b8642bedf905c3d358573d3f27fbbd3b3cb9aaaf")), new BigInteger("883423532389192164791648750360308884807550341691627752275345424702807307"));
            ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
            ECKeyGenerationParameters eCKeyGenerationParameters = new ECKeyGenerationParameters(eCDomainParameters, secureRandom);
            eCKeyPairGenerator.init((KeyGenerationParameters)eCKeyGenerationParameters);
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = eCKeyPairGenerator.generateKeyPair();
            AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = eCKeyPairGenerator.generateKeyPair();
            ECDHBasicAgreement eCDHBasicAgreement = new ECDHBasicAgreement();
            ECDHBasicAgreement eCDHBasicAgreement2 = new ECDHBasicAgreement();
            eCDHBasicAgreement.init(asymmetricCipherKeyPair.getPrivate());
            eCDHBasicAgreement2.init(asymmetricCipherKeyPair2.getPrivate());
            BigInteger bigInteger = eCDHBasicAgreement.calculateAgreement(asymmetricCipherKeyPair2.getPublic());
            BigInteger bigInteger2 = eCDHBasicAgreement2.calculateAgreement(asymmetricCipherKeyPair.getPublic());
            if (!bigInteger.equals(bigInteger2)) {
                return new SimpleTestResult(false, this.getName() + ": calculated agreement test failed");
            }
            eCDHBasicAgreement = new ECDHCBasicAgreement();
            eCDHBasicAgreement2 = new ECDHCBasicAgreement();
            eCDHBasicAgreement.init(asymmetricCipherKeyPair.getPrivate());
            eCDHBasicAgreement2.init(asymmetricCipherKeyPair2.getPrivate());
            bigInteger = eCDHBasicAgreement.calculateAgreement(asymmetricCipherKeyPair2.getPublic());
            bigInteger2 = eCDHBasicAgreement2.calculateAgreement(asymmetricCipherKeyPair.getPublic());
            if (!bigInteger.equals(bigInteger2)) {
                return new SimpleTestResult(false, this.getName() + ": calculated agreement test failed");
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
    }

    private class ECDSAKeyGenTest
    implements Test {
        private ECDSAKeyGenTest() {
        }

        public String getName() {
            return "ECDSA key generation test";
        }

        public TestResult perform() {
            SecureRandom secureRandom = new SecureRandom();
            ECCurve.Fp fp = new ECCurve.Fp(new BigInteger("883423532389192164791648750360308885314476597252960362792450860609699839"), new BigInteger("7fffffffffffffffffffffff7fffffffffff8000000000007ffffffffffc", 16), new BigInteger("6b016c3bdcf18941d0d654921475ca71a9db2fb27d1d37796185c2942c0a", 16));
            ECDomainParameters eCDomainParameters = new ECDomainParameters((ECCurve)fp, fp.decodePoint(Hex.decode((String)"020ffa963cdca8816ccc33b8642bedf905c3d358573d3f27fbbd3b3cb9aaaf")), new BigInteger("883423532389192164791648750360308884807550341691627752275345424702807307"));
            ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
            ECKeyGenerationParameters eCKeyGenerationParameters = new ECKeyGenerationParameters(eCDomainParameters, secureRandom);
            eCKeyPairGenerator.init((KeyGenerationParameters)eCKeyGenerationParameters);
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = eCKeyPairGenerator.generateKeyPair();
            ParametersWithRandom parametersWithRandom = new ParametersWithRandom(asymmetricCipherKeyPair.getPrivate(), secureRandom);
            ECDSASigner eCDSASigner = new ECDSASigner();
            eCDSASigner.init(true, (CipherParameters)parametersWithRandom);
            byte[] byArray = new BigInteger("968236873715988614170569073515315707566766479517").toByteArray();
            BigInteger[] bigIntegerArray = eCDSASigner.generateSignature(byArray);
            eCDSASigner.init(false, asymmetricCipherKeyPair.getPublic());
            if (eCDSASigner.verifySignature(byArray, bigIntegerArray[0], bigIntegerArray[1])) {
                return new SimpleTestResult(true, this.getName() + ": Okay");
            }
            return new SimpleTestResult(false, this.getName() + ": signature fails");
        }
    }

    private class ECDSA239bitPrime
    implements Test {
        BigInteger r = new BigInteger("308636143175167811492622547300668018854959378758531778147462058306432176");
        BigInteger s = new BigInteger("323813553209797357708078776831250505931891051755007842781978505179448783");
        SecureRandom k = new SecureRandom(this){
            private final /* synthetic */ ECDSA239bitPrime this$1;
            {
                this.this$1 = eCDSA239bitPrime;
            }

            public void nextBytes(byte[] byArray) {
                byte[] byArray2 = new BigInteger("700000017569056646655505781757157107570501575775705779575555657156756655").toByteArray();
                System.arraycopy(byArray2, byArray2.length - byArray.length, byArray, 0, byArray.length);
            }
        };

        private ECDSA239bitPrime() {
        }

        public String getName() {
            return "ECDSA 239 bit prime";
        }

        public TestResult perform() {
            ECCurve.Fp fp = new ECCurve.Fp(new BigInteger("883423532389192164791648750360308885314476597252960362792450860609699839"), new BigInteger("7fffffffffffffffffffffff7fffffffffff8000000000007ffffffffffc", 16), new BigInteger("6b016c3bdcf18941d0d654921475ca71a9db2fb27d1d37796185c2942c0a", 16));
            ECDomainParameters eCDomainParameters = new ECDomainParameters((ECCurve)fp, fp.decodePoint(Hex.decode((String)"020ffa963cdca8816ccc33b8642bedf905c3d358573d3f27fbbd3b3cb9aaaf")), new BigInteger("883423532389192164791648750360308884807550341691627752275345424702807307"));
            ECPrivateKeyParameters eCPrivateKeyParameters = new ECPrivateKeyParameters(new BigInteger("876300101507107567501066130761671078357010671067781776716671676178726717"), eCDomainParameters);
            ECDSASigner eCDSASigner = new ECDSASigner();
            ParametersWithRandom parametersWithRandom = new ParametersWithRandom((CipherParameters)eCPrivateKeyParameters, this.k);
            eCDSASigner.init(true, (CipherParameters)parametersWithRandom);
            byte[] byArray = new BigInteger("968236873715988614170569073515315707566766479517").toByteArray();
            BigInteger[] bigIntegerArray = eCDSASigner.generateSignature(byArray);
            if (!this.r.equals(bigIntegerArray[0])) {
                return new SimpleTestResult(false, this.getName() + ": r component wrong." + System.getProperty("line.separator") + " expecting: " + this.r + System.getProperty("line.separator") + " got      : " + bigIntegerArray[0]);
            }
            if (!this.s.equals(bigIntegerArray[1])) {
                return new SimpleTestResult(false, this.getName() + ": s component wrong." + System.getProperty("line.separator") + " expecting: " + this.s + System.getProperty("line.separator") + " got      : " + bigIntegerArray[1]);
            }
            ECPublicKeyParameters eCPublicKeyParameters = new ECPublicKeyParameters(fp.decodePoint(Hex.decode((String)"025b6dc53bc61a2548ffb0f671472de6c9521a9d2d2534e65abfcbd5fe0c70")), eCDomainParameters);
            eCDSASigner.init(false, (CipherParameters)eCPublicKeyParameters);
            if (eCDSASigner.verifySignature(byArray, bigIntegerArray[0], bigIntegerArray[1])) {
                return new SimpleTestResult(true, this.getName() + ": Okay");
            }
            return new SimpleTestResult(false, this.getName() + ": signature fails");
        }
    }

    private class ECDSA192bitPrime
    implements Test {
        BigInteger r = new BigInteger("3342403536405981729393488334694600415596881826869351677613");
        BigInteger s = new BigInteger("5735822328888155254683894997897571951568553642892029982342");
        SecureRandom k = new SecureRandom(){

            public void nextBytes(byte[] byArray) {
                byte[] byArray2 = new BigInteger("6140507067065001063065065565667405560006161556565665656654").toByteArray();
                System.arraycopy(byArray2, byArray2.length - byArray.length, byArray, 0, byArray.length);
            }
        };

        private ECDSA192bitPrime() {
        }

        public String getName() {
            return "ECDSA 192 bit prime";
        }

        public TestResult perform() {
            ECCurve.Fp fp = new ECCurve.Fp(new BigInteger("6277101735386680763835789423207666416083908700390324961279"), new BigInteger("fffffffffffffffffffffffffffffffefffffffffffffffc", 16), new BigInteger("64210519e59c80e70fa7e9ab72243049feb8deecc146b9b1", 16));
            ECDomainParameters eCDomainParameters = new ECDomainParameters((ECCurve)fp, fp.decodePoint(Hex.decode((String)"03188da80eb03090f67cbf20eb43a18800f4ff0afd82ff1012")), new BigInteger("6277101735386680763835789423176059013767194773182842284081"));
            ECPrivateKeyParameters eCPrivateKeyParameters = new ECPrivateKeyParameters(new BigInteger("651056770906015076056810763456358567190100156695615665659"), eCDomainParameters);
            ParametersWithRandom parametersWithRandom = new ParametersWithRandom((CipherParameters)eCPrivateKeyParameters, this.k);
            ECDSASigner eCDSASigner = new ECDSASigner();
            eCDSASigner.init(true, (CipherParameters)parametersWithRandom);
            byte[] byArray = new BigInteger("968236873715988614170569073515315707566766479517").toByteArray();
            BigInteger[] bigIntegerArray = eCDSASigner.generateSignature(byArray);
            if (!this.r.equals(bigIntegerArray[0])) {
                return new SimpleTestResult(false, this.getName() + ": r component wrong." + System.getProperty("line.separator") + " expecting: " + this.r + System.getProperty("line.separator") + " got      : " + bigIntegerArray[0]);
            }
            if (!this.s.equals(bigIntegerArray[1])) {
                return new SimpleTestResult(false, this.getName() + ": s component wrong." + System.getProperty("line.separator") + " expecting: " + this.s + System.getProperty("line.separator") + " got      : " + bigIntegerArray[1]);
            }
            ECPublicKeyParameters eCPublicKeyParameters = new ECPublicKeyParameters(fp.decodePoint(Hex.decode((String)"0262b12d60690cdcf330babab6e69763b471f994dd702d16a5")), eCDomainParameters);
            eCDSASigner.init(false, (CipherParameters)eCPublicKeyParameters);
            if (eCDSASigner.verifySignature(byArray, bigIntegerArray[0], bigIntegerArray[1])) {
                return new SimpleTestResult(true, this.getName() + ": Okay");
            }
            return new SimpleTestResult(false, this.getName() + ": verification fails");
        }
    }
}

