/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.digests.RIPEMD128Digest;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class RIPEMD128DigestTest
implements Test {
    static final String[] messages = new String[]{"", "a", "abc", "message digest", "abcdefghijklmnopqrstuvwxyz", "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "12345678901234567890123456789012345678901234567890123456789012345678901234567890"};
    static final String[] digests = new String[]{"cdf26213a150dc3ecb610f18f6b38b46", "86be7afa339d0fc7cfc785e72f578d33", "c14a12199c66e4ba84636b0f69144c77", "9e327b3d6e523062afc1132d7df9d1b8", "fd2aa607f71dc8f510714922b371834e", "a1aa0689d0fafa2ddc22e88b49133a06", "d1e959eb179c911faea4624c60c5c702", "3f45ef194732c2dbb2c4a2c769795fa3"};
    static final String million_a_digest = "4a7f5723f954eba1216c9d8f6320431f";

    public static boolean arraysEqual(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String getName() {
        return "RIPEMD128";
    }

    public TestResult perform() {
        byte[] byArray;
        RIPEMD128Digest rIPEMD128Digest = new RIPEMD128Digest();
        byte[] byArray2 = new byte[rIPEMD128Digest.getDigestSize()];
        int n = 0;
        while (n < messages.length) {
            byArray = messages[n].getBytes();
            rIPEMD128Digest.update(byArray, 0, byArray.length);
            rIPEMD128Digest.doFinal(byArray2, 0);
            if (!RIPEMD128DigestTest.arraysEqual(byArray2, Hex.decode((String)digests[n]))) {
                return new SimpleTestResult(false, this.getName() + ": Vector " + n + " failed");
            }
            ++n;
        }
        byArray = messages[messages.length - 1].getBytes();
        rIPEMD128Digest.update(byArray, 0, byArray.length / 2);
        RIPEMD128Digest rIPEMD128Digest2 = new RIPEMD128Digest(rIPEMD128Digest);
        rIPEMD128Digest.update(byArray, byArray.length / 2, byArray.length - byArray.length / 2);
        rIPEMD128Digest.doFinal(byArray2, 0);
        if (!RIPEMD128DigestTest.arraysEqual(byArray2, Hex.decode((String)digests[digests.length - 1]))) {
            return new SimpleTestResult(false, "RIPEMD128 failing clone test" + System.getProperty("line.separator") + "    expected: " + digests[digests.length - 1] + System.getProperty("line.separator") + "    got     : " + new String(Hex.encode((byte[])byArray2)));
        }
        rIPEMD128Digest2.update(byArray, byArray.length / 2, byArray.length - byArray.length / 2);
        rIPEMD128Digest2.doFinal(byArray2, 0);
        if (!RIPEMD128DigestTest.arraysEqual(byArray2, Hex.decode((String)digests[digests.length - 1]))) {
            return new SimpleTestResult(false, "RIPEMD128 failing clone test - part 2" + System.getProperty("line.separator") + "    expected: " + digests[digests.length - 1] + System.getProperty("line.separator") + "    got     : " + new String(Hex.encode((byte[])byArray2)));
        }
        int n2 = 0;
        while (n2 < 1000000) {
            rIPEMD128Digest.update((byte)97);
            ++n2;
        }
        rIPEMD128Digest.doFinal(byArray2, 0);
        if (!RIPEMD128DigestTest.arraysEqual(byArray2, Hex.decode((String)million_a_digest))) {
            return new SimpleTestResult(false, this.getName() + ": Million a's failed");
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] stringArray) {
        RIPEMD128DigestTest rIPEMD128DigestTest = new RIPEMD128DigestTest();
        TestResult testResult = rIPEMD128DigestTest.perform();
        System.out.println(testResult);
    }
}

