package org.bouncycastle.asn1;

import java.io.IOException;
import java.io.UnsupportedEncodingException;

/**
 * DER BMPString object.
 */
public class DERBMPString
    extends DERObject
    implements DERString
{
    String  string;

    /**
     * basic constructor - byte encoded string.
     */
    public DERBMPString(
        byte[]   string)
    {
	    try
	    {
            this.string = new String(string, "UnicodeBig");
	    }
	    catch (UnsupportedEncodingException e)
	    {
            throw new RuntimeException(e.toString());
	    }
    }

    /**
     * basic constructor
     */
    public DERBMPString(
        String   string)
    {
        this.string = string;
    }

    public String getString()
    {
        return string;
    }

    void encode(
        DEROutputStream  out)
        throws IOException
    {
        char[]  c = string.toCharArray();
        byte[]  b = new byte[c.length * 2];

        for (int i = 0; i != c.length; i++)
        {
            b[2 * i] = (byte)((c[i] & 0xff00) >> 8);
            b[2 * i + 1] = (byte)c[i];
        }

        out.writeEncoded(BMP_STRING, b);
    }
}
