package org.bouncycastle.openssl.test;

import java.io.*;
import java.security.*;

import org.bouncycastle.openssl.*;

/**
 * basic class for reading test.pem - the password is "secret"
 */
public class ReaderTest
{
    private static class Password
        implements PasswordFinder
    {
        char[]  password;

        Password(
            char[] word)
        {
            this.password = word;
        }

        public char[] getPassword()
        {
            return password;
        }
    }

    public static void main(
        String[]  args)
        throws Exception
    {
        FileReader      fRd = new FileReader(args[0]);
        PasswordFinder  pGet = new Password(args[1].toCharArray());
        PEMReader       pemRd = new PEMReader(fRd, pGet);
        Object          o;

        while ((o = pemRd.readObject()) != null)
        {
            if (o instanceof KeyPair)
            {
                KeyPair     pair = (KeyPair)o;

                System.out.println(pair.getPublic());
                System.out.println(pair.getPrivate());
            }
            else
            {
                System.out.println(o.toString());
            }
        }
    }
}
