/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.ArrayList;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.HashAlgorithmTags;
import org.bouncycastle.bcpg.PacketTags;
import org.bouncycastle.bcpg.PublicKeyAlgorithmTags;
import org.bouncycastle.bcpg.PublicKeyEncSessionPacket;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.SymmetricKeyAlgorithmTags;
import org.bouncycastle.bcpg.SymmetricKeyEncSessionPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPUtil;

public class PGPEncryptedDataGenerator
implements PacketTags,
PublicKeyAlgorithmTags,
SymmetricKeyAlgorithmTags,
HashAlgorithmTags {
    private BCPGOutputStream pkOut;
    private CipherOutputStream cOut;
    private boolean withIntegrityPacket = false;
    private ArrayList methods = new ArrayList();
    private int defAlgorithm;
    private SecureRandom rand;
    private String defProvider;

    private static Cipher getKeyCipher(int n, String string) throws NoSuchProviderException, PGPException {
        try {
            switch (n) {
                case 1: 
                case 2: {
                    return Cipher.getInstance("RSA/ECB/PKCS1Padding", string);
                }
                case 16: 
                case 20: {
                    return Cipher.getInstance("ElGamal", string);
                }
            }
            throw new PGPException("unknown asymmetric algorithm: " + n);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw noSuchProviderException;
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception creating cipher", exception);
        }
    }

    public PGPEncryptedDataGenerator(int n, SecureRandom secureRandom, String string) {
        this.defAlgorithm = n;
        this.rand = secureRandom;
        this.defProvider = string;
    }

    public void addMethod(char[] cArray) throws NoSuchProviderException, PGPException {
        byte[] byArray = new byte[8];
        this.rand.nextBytes(byArray);
        S2K s2K = new S2K(2, byArray, 96);
        this.methods.add(new PBEMethod(this.defAlgorithm, s2K, PGPUtil.makeKeyFromPassPhrase(this.defAlgorithm, s2K, cArray, this.defProvider)));
    }

    public void addMethod(PGPPublicKey pGPPublicKey) throws NoSuchProviderException, PGPException {
        byte[] byArray = new byte[8];
        this.rand.nextBytes(byArray);
        S2K s2K = new S2K(2, byArray, 96);
        this.methods.add(new PubMethod(pGPPublicKey));
    }

    private void addCheckSum(byte[] byArray) {
        int n = 0;
        int n2 = 1;
        while (n2 != byArray.length - 2) {
            n += byArray[n2] & 0xFF;
            ++n2;
        }
        byArray[byArray.length - 2] = (byte)(n >> 8);
        byArray[byArray.length - 1] = (byte)n;
    }

    public OutputStream open(OutputStream outputStream, long l) throws IOException, PGPException {
        Object object;
        Object object2;
        BCPGOutputStream bCPGOutputStream = new BCPGOutputStream(outputStream);
        Key key = null;
        if (this.methods.size() == 0) {
            throw new IllegalStateException("no encryption methods specified");
        }
        if (this.methods.size() == 1) {
            if (this.methods.get(0) instanceof PBEMethod) {
                object2 = (PBEMethod)this.methods.get(0);
                key = object2.getKey();
            } else {
                key = PGPUtil.makeRandomKey(this.defAlgorithm, this.rand);
                object2 = key.getEncoded();
                object = new byte[((byte[])object2).length + 3];
                object[0] = (byte)this.defAlgorithm;
                System.arraycopy(object2, 0, object, 1, ((byte[])object2).length);
                this.addCheckSum((byte[])object);
                PubMethod pubMethod = (PubMethod)this.methods.get(0);
                try {
                    pubMethod.addSessionInfo((byte[])object);
                }
                catch (Exception exception) {
                    throw new PGPException("exception encrypting session key", exception);
                }
            }
            bCPGOutputStream.writePacket((ContainedPacket)this.methods.get(0));
        } else {
            key = PGPUtil.makeRandomKey(this.defAlgorithm, this.rand);
            object2 = key.getEncoded();
            object = new byte[((byte[])object2).length + 3];
            object[0] = (byte)this.defAlgorithm;
            System.arraycopy(object2, 0, object, 1, ((byte[])object2).length);
            this.addCheckSum((byte[])object);
            int n = 0;
            while (n != this.methods.size()) {
                EncMethod encMethod = (EncMethod)this.methods.get(n);
                try {
                    encMethod.addSessionInfo((byte[])object);
                }
                catch (Exception exception) {
                    throw new PGPException("exception encrypting session key", exception);
                }
                bCPGOutputStream.writePacket(encMethod);
                ++n;
            }
        }
        object2 = PGPUtil.getSymmetricCipherName(this.defAlgorithm);
        if (object2 != null) {
            try {
                if (this.withIntegrityPacket) {
                    object = Cipher.getInstance((String)object2 + "/CFB/NoPadding", this.defProvider);
                    ((Cipher)object).init(1, key, new IvParameterSpec(new byte[((Cipher)object).getBlockSize()]));
                } else {
                    object = Cipher.getInstance((String)object2 + "/PGPCFBwithIv/NoPadding", this.defProvider);
                    ((Cipher)object).init(1, key, this.rand);
                }
                bCPGOutputStream = new BCPGOutputStream(outputStream, 9, l + (long)((Cipher)object).getBlockSize() + 2L);
                this.cOut = new CipherOutputStream(bCPGOutputStream, (Cipher)object);
                if (this.withIntegrityPacket) {
                    byte[] byArray = new byte[((Cipher)object).getBlockSize() + 2];
                    this.rand.nextBytes(byArray);
                    byArray[byArray.length - 1] = byArray[byArray.length - 3];
                    byArray[byArray.length - 2] = byArray[byArray.length - 4];
                    this.cOut.write(byArray);
                }
                return this.cOut;
            }
            catch (Exception exception) {
                throw new PGPException("Exception creating cipher", exception);
            }
        }
        throw new PGPException("null cipher specified");
    }

    public void close() throws IOException {
        if (this.cOut != null) {
            this.cOut.flush();
        }
    }

    private class PubMethod
    extends EncMethod {
        PGPPublicKey pubKey;
        BigInteger[] data;

        PubMethod(PGPPublicKey pGPPublicKey) {
            this.pubKey = pGPPublicKey;
        }

        public void addSessionInfo(byte[] byArray) throws Exception {
            Cipher cipher;
            String string = PGPUtil.getSymmetricCipherName(this.encAlgorithm);
            switch (this.pubKey.getAlgorithm()) {
                case 1: 
                case 2: {
                    cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", PGPEncryptedDataGenerator.this.defProvider);
                    break;
                }
                case 16: 
                case 20: {
                    cipher = Cipher.getInstance("ElGamal/ECB/PKCS1Padding", PGPEncryptedDataGenerator.this.defProvider);
                    break;
                }
                case 17: {
                    throw new PGPException("Can't use DSA for encryption.");
                }
                case 19: {
                    throw new PGPException("Can't use ECDSA for encryption.");
                }
                default: {
                    throw new PGPException("unknown asymmetric algorithm: " + this.pubKey.getAlgorithm());
                }
            }
            PublicKey publicKey = this.pubKey.getKey(PGPEncryptedDataGenerator.this.defProvider);
            cipher.init(1, publicKey);
            byte[] byArray2 = cipher.doFinal(byArray);
            switch (this.pubKey.getAlgorithm()) {
                case 1: 
                case 2: {
                    this.data = new BigInteger[1];
                    this.data[0] = new BigInteger(1, byArray2);
                    break;
                }
                case 16: 
                case 20: {
                    byte[] byArray3 = new byte[byArray2.length / 2];
                    byte[] byArray4 = new byte[byArray2.length / 2];
                    System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
                    System.arraycopy(byArray2, byArray3.length, byArray4, 0, byArray4.length);
                    this.data = new BigInteger[2];
                    this.data[0] = new BigInteger(1, byArray3);
                    this.data[1] = new BigInteger(1, byArray4);
                    break;
                }
                default: {
                    throw new PGPException("unknown asymmetric algorithm: " + this.encAlgorithm);
                }
            }
        }

        public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
            PublicKeyEncSessionPacket publicKeyEncSessionPacket = new PublicKeyEncSessionPacket(this.pubKey.getKeyID(), this.pubKey.getAlgorithm(), this.data);
            bCPGOutputStream.writePacket(publicKeyEncSessionPacket);
        }
    }

    private class PBEMethod
    extends EncMethod {
        S2K s2k;

        PBEMethod(int n, S2K s2K, Key key) {
            this.encAlgorithm = n;
            this.s2k = s2K;
            this.key = key;
        }

        public Key getKey() {
            return this.key;
        }

        public void addSessionInfo(byte[] byArray) throws Exception {
            String string = PGPUtil.getSymmetricCipherName(this.encAlgorithm);
            Cipher cipher = Cipher.getInstance(string + "/CFB/NoPadding", PGPEncryptedDataGenerator.this.defProvider);
            cipher.init(1, this.key, new IvParameterSpec(new byte[cipher.getBlockSize()]), PGPEncryptedDataGenerator.this.rand);
            this.sessionInfo = cipher.doFinal(byArray, 0, byArray.length - 2);
        }

        public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
            SymmetricKeyEncSessionPacket symmetricKeyEncSessionPacket = new SymmetricKeyEncSessionPacket(this.encAlgorithm, this.s2k, this.sessionInfo);
            bCPGOutputStream.writePacket(symmetricKeyEncSessionPacket);
        }
    }

    private abstract class EncMethod
    extends ContainedPacket {
        protected byte[] sessionInfo;
        protected int encAlgorithm;
        protected Key key;

        private EncMethod() {
        }

        public abstract void addSessionInfo(byte[] var1) throws Exception;
    }
}

