/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchProviderException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.HashAlgorithmTags;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.bcpg.PacketTags;
import org.bouncycastle.bcpg.PublicKeyAlgorithmTags;
import org.bouncycastle.bcpg.PublicKeyEncSessionPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.bcpg.SymmetricKeyAlgorithmTags;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPUtil;

public class PGPPublicKeyEncryptedData
implements PacketTags,
PublicKeyAlgorithmTags,
SymmetricKeyAlgorithmTags,
HashAlgorithmTags {
    PublicKeyEncSessionPacket keyData;
    InputStreamPacket encData;

    PGPPublicKeyEncryptedData(PublicKeyEncSessionPacket publicKeyEncSessionPacket, InputStreamPacket inputStreamPacket) {
        this.keyData = publicKeyEncSessionPacket;
        this.encData = inputStreamPacket;
    }

    private static Cipher getKeyCipher(int n, String string) throws NoSuchProviderException, PGPException {
        try {
            switch (n) {
                case 1: 
                case 2: {
                    return Cipher.getInstance("RSA/ECB/PKCS1Padding", string);
                }
                case 16: 
                case 20: {
                    return Cipher.getInstance("ElGamal/ECB/PKCS1Padding", string);
                }
            }
            throw new PGPException("unknown asymmetric algorithm: " + n);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw noSuchProviderException;
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception creating cipher", exception);
        }
    }

    public long getKeyID() {
        return this.keyData.getKeyID();
    }

    public InputStream getInputStream() {
        return this.encData.getInputStream();
    }

    public InputStream getDataStream(PGPPrivateKey pGPPrivateKey, String string) throws PGPException, NoSuchProviderException {
        Cipher cipher;
        byte[] byArray;
        Cipher cipher2 = PGPPublicKeyEncryptedData.getKeyCipher(this.keyData.getAlgorithm(), string);
        try {
            cipher2.init(2, pGPPrivateKey.getKey());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PGPException("error setting asymmetric cipher", invalidKeyException);
        }
        BigInteger[] bigIntegerArray = this.keyData.getEncSessionKey();
        int n = 0;
        while (n != bigIntegerArray.length) {
            byArray = bigIntegerArray[n].toByteArray();
            if (byArray[0] == 0) {
                cipher2.update(byArray, 1, byArray.length - 1);
            } else {
                cipher2.update(byArray);
            }
            ++n;
        }
        try {
            byArray = cipher2.doFinal();
        }
        catch (Exception exception) {
            throw new PGPException("exception decrypting secret key", exception);
        }
        try {
            cipher = this.encData instanceof SymmetricEncIntegrityPacket ? Cipher.getInstance(PGPUtil.getSymmetricCipherName(byArray[0]) + "/CFB/NoPadding", string) : Cipher.getInstance(PGPUtil.getSymmetricCipherName(byArray[0]) + "/PGPCFBwithIV/NoPadding", string);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw noSuchProviderException;
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("exception creating cipher", exception);
        }
        if (cipher != null) {
            try {
                SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, 1, byArray.length - 3, PGPUtil.getSymmetricCipherName(byArray[0]));
                BCPGInputStream bCPGInputStream = this.encData.getInputStream();
                byte[] byArray2 = new byte[cipher.getBlockSize()];
                if (this.encData instanceof SymmetricEncIntegrityPacket) {
                    cipher.init(2, (Key)secretKeySpec, new IvParameterSpec(byArray2));
                    bCPGInputStream = new BCPGInputStream(new CipherInputStream(bCPGInputStream, cipher));
                    bCPGInputStream.readFully(byArray2);
                    bCPGInputStream.read();
                    bCPGInputStream.read();
                    return bCPGInputStream;
                }
                cipher.init(2, secretKeySpec);
                return new CipherInputStream(bCPGInputStream, cipher);
            }
            catch (Exception exception) {
                throw new PGPException("Exception starting decryption", exception);
            }
        }
        return this.encData.getInputStream();
    }
}

