/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.examples;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureList;

public class ClearSignedFileProcessor {
    private static void verifyFile(InputStream inputStream, InputStream inputStream2) throws Exception {
        int n;
        int n2 = 0;
        while ((n = inputStream.read()) >= 0) {
            if (n == 10 && ++n2 == 3) break;
        }
        boolean bl = false;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read()) >= 0 && !bl && n != 45) {
            if (bl) {
                byteArrayOutputStream.write(13);
                byteArrayOutputStream.write(10);
                bl = false;
            }
            if (n == 13) continue;
            if (n == 10) {
                bl = true;
                continue;
            }
            byteArrayOutputStream.write((byte)n);
        }
        inputStream = new ArmoredInputStream(inputStream);
        PGPPublicKeyRing pGPPublicKeyRing = new PGPPublicKeyRing(new BCPGInputStream(inputStream2));
        PGPObjectFactory pGPObjectFactory = new PGPObjectFactory(inputStream);
        PGPSignatureList pGPSignatureList = (PGPSignatureList)pGPObjectFactory.nextObject();
        PGPSignature pGPSignature = pGPSignatureList.get(0);
        pGPSignature.initVerify(pGPPublicKeyRing.getPublicKey(), "BC");
        pGPSignature.update(byteArrayOutputStream.toByteArray());
        if (pGPSignature.verify()) {
            System.out.println("signature verified.");
        } else {
            System.out.println("signature verification failed.");
        }
    }

    private static void signFile(String string, InputStream inputStream, OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, PGPException, SignatureException {
        PGPSecretKeyRing pGPSecretKeyRing = new PGPSecretKeyRing(new BCPGInputStream(inputStream));
        PGPPrivateKey pGPPrivateKey = pGPSecretKeyRing.getSecretKey().extractPrivateKey(cArray, "BC");
        PGPSignatureGenerator pGPSignatureGenerator = new PGPSignatureGenerator(1, 2, "BC");
        pGPSignatureGenerator.initSign(1, pGPPrivateKey);
        FileInputStream fileInputStream = new FileInputStream(string);
        int n = 0;
        outputStream.write("-----BEGIN PGP SIGNED MESSAGE-----\n".getBytes());
        outputStream.write("Hash: SHA1\n\n".getBytes());
        boolean bl = false;
        while ((n = fileInputStream.read()) >= 0) {
            outputStream.write(n);
            if (bl) {
                pGPSignatureGenerator.update((byte)13);
                pGPSignatureGenerator.update((byte)10);
                bl = false;
            }
            if (n == 13) continue;
            if (n == 10) {
                bl = true;
                continue;
            }
            pGPSignatureGenerator.update((byte)n);
        }
        outputStream = new ArmoredOutputStream(outputStream);
        BCPGOutputStream bCPGOutputStream = new BCPGOutputStream(outputStream);
        pGPSignatureGenerator.generate().encode(bCPGOutputStream);
        outputStream.close();
    }

    public static void main(String[] stringArray) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (stringArray[0].equals("-s")) {
            FileInputStream fileInputStream = new FileInputStream(stringArray[2]);
            FileOutputStream fileOutputStream = new FileOutputStream(stringArray[1] + ".asc");
            ClearSignedFileProcessor.signFile(stringArray[1], fileInputStream, fileOutputStream, stringArray[3].toCharArray());
        } else if (stringArray[0].equals("-v")) {
            FileInputStream fileInputStream = new FileInputStream(stringArray[1]);
            FileInputStream fileInputStream2 = new FileInputStream(stringArray[2]);
            ClearSignedFileProcessor.verifyFile(fileInputStream, fileInputStream2);
        } else {
            System.err.println("usage: ClearSignedFileProcessor [-s file keyfile passPhrase]|[-v sigFile keyFile]");
        }
    }
}

