/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.examples;

import java.io.FileInputStream;
import java.security.Provider;
import java.security.Security;
import java.util.Iterator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.util.encoders.Hex;

public class PubringDump {
    public static String getAlgorithm(int n) {
        switch (n) {
            case 1: {
                return "RSA_GENERAL";
            }
            case 2: {
                return "RSA_ENCRYPT";
            }
            case 3: {
                return "RSA_SIGN";
            }
            case 16: {
                return "ELGAMAL_ENCRYPT";
            }
            case 17: {
                return "DSA";
            }
            case 18: {
                return "EC";
            }
            case 19: {
                return "ECDSA";
            }
            case 20: {
                return "ELGAMAL_GENERAL";
            }
            case 21: {
                return "DIFFIE_HELLMAN";
            }
        }
        return "unknown";
    }

    public static void main(String[] stringArray) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        PGPPublicKey pGPPublicKey = null;
        Object var2_2 = null;
        PGPUtil.setDefaultProvider("BC");
        PGPObjectFactory pGPObjectFactory = new PGPObjectFactory(new FileInputStream(stringArray[0]));
        PGPPublicKeyRing pGPPublicKeyRing = null;
        while ((pGPPublicKeyRing = (PGPPublicKeyRing)pGPObjectFactory.nextObject()) != null) {
            try {
                pGPPublicKey = pGPPublicKeyRing.getPublicKey();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            long l = 0L;
            Object var7_7 = null;
            Iterator iterator = pGPPublicKeyRing.getPublicKeys();
            boolean bl = true;
            while (iterator.hasNext()) {
                PGPPublicKey pGPPublicKey2 = (PGPPublicKey)iterator.next();
                if (bl) {
                    System.out.println("Key ID: " + Long.toHexString(pGPPublicKey2.getKeyID()));
                    bl = false;
                } else {
                    System.out.println("Key ID: " + Long.toHexString(pGPPublicKey2.getKeyID()) + " (subkey)");
                }
                System.out.println("            Algorithm: " + PubringDump.getAlgorithm(pGPPublicKey2.getAlgorithm()));
                System.out.println("            Fingerprint: " + new String(Hex.encode((byte[])pGPPublicKey2.getFingerprint())));
            }
        }
    }
}

