package org.bouncycastle.bcpg;

import java.io.IOException;

/**
 * Basic type for a trust packet
 */
public class TrustPacket 
	extends ContainedPacket
{	
	byte[]	levelAndTrustAmount = new byte[2];
	
	public TrustPacket(
		BCPGInputStream  in)
		throws IOException
	{
		if (in.available() == 2)
		{
			in.readFully(levelAndTrustAmount);
		}
		else
		{
			int	v = in.read();
			
			if (v >= 0)
			{
				levelAndTrustAmount[0] = (byte)v;
			}
		}
	}
	
	public void encode(
		BCPGOutputStream	out)
		throws IOException
	{
		out.writePacket(TRUST, levelAndTrustAmount, true);
	}
}
