/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.GeneralName;

public class AuthorityInformationAccess
extends ASN1Encodable {
    DERObjectIdentifier accessMethod = null;
    GeneralName accessLocation = null;

    public AuthorityInformationAccess(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        if (enumeration.hasMoreElements()) {
            DERSequence dERSequence = (DERSequence)enumeration.nextElement();
            if (dERSequence.size() != 2) {
                throw new IllegalArgumentException("wrong number of elements in inner sequence");
            }
            this.accessMethod = (DERObjectIdentifier)dERSequence.getObjectAt(0);
            this.accessLocation = (GeneralName)dERSequence.getObjectAt(1);
        }
    }

    public AuthorityInformationAccess(DERObjectIdentifier dERObjectIdentifier, GeneralName generalName) {
        this.accessMethod = dERObjectIdentifier;
        this.accessLocation = generalName;
    }

    public AuthorityInformationAccess getInstance(Object object) {
        if (object instanceof AuthorityInformationAccess) {
            return (AuthorityInformationAccess)object;
        }
        if (object instanceof ASN1Sequence) {
            return new AuthorityInformationAccess((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.accessMethod);
        aSN1EncodableVector.add(this.accessLocation);
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        aSN1EncodableVector2.add(new DERSequence(aSN1EncodableVector));
        return new DERSequence(aSN1EncodableVector2);
    }

    public String toString() {
        return "AuthorityInformationAccess: Oid(" + this.accessMethod.getId() + ")";
    }
}

