/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime;

import java.io.IOException;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import org.bouncycastle.cms.CMSCompressedData;
import org.bouncycastle.cms.CMSCompressedDataGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.mail.smime.CMSProcessableBodyPart;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMEGenerator;
import org.bouncycastle.util.encoders.Base64;

public class SMIMECompressedGenerator
extends SMIMEGenerator {
    public static final String ZLIB = "1.2.840.113549.1.9.16.3.8";
    private CMSCompressedDataGenerator fact = new CMSCompressedDataGenerator();

    private MimeBodyPart make(MimeBodyPart mimeBodyPart, String string) throws SMIMEException {
        CMSCompressedData cMSCompressedData;
        try {
            cMSCompressedData = this.fact.generate(new CMSProcessableBodyPart((BodyPart)mimeBodyPart), string);
        }
        catch (CMSException cMSException) {
            throw new SMIMEException(cMSException.getMessage(), cMSException.getUnderlyingException());
        }
        InternetHeaders internetHeaders = new InternetHeaders();
        internetHeaders.addHeader("Content-Type", "application/pkcs7-mime; name=\"smime.p7m\"; smime-type=compressed-data");
        internetHeaders.addHeader("Content-Disposition", "attachment; filename=\"smime.p7m\"");
        internetHeaders.addHeader("Content-Description", "S/MIME Encrypted Message");
        try {
            MimeBodyPart mimeBodyPart2;
            if (this.useBase64) {
                internetHeaders.addHeader("Content-Transfer-Encoding", "base64");
                mimeBodyPart2 = new MimeBodyPart(internetHeaders, Base64.encode((byte[])cMSCompressedData.getEncoded()));
            } else {
                internetHeaders.addHeader("Content-Transfer-Encoding", this.encoding);
                mimeBodyPart2 = new MimeBodyPart(internetHeaders, cMSCompressedData.getEncoded());
            }
            return mimeBodyPart2;
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("exception putting multi-part together.", (Exception)((Object)messagingException));
        }
        catch (IOException iOException) {
            throw new SMIMEException("exception generating encoded content", iOException);
        }
    }

    public MimeBodyPart generate(MimeBodyPart mimeBodyPart, String string) throws SMIMEException {
        return this.make(this.makeContentBodyPart(mimeBodyPart), string);
    }

    public MimeBodyPart generate(MimeMessage mimeMessage, String string) throws SMIMEException {
        try {
            mimeMessage.saveChanges();
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("unable to save message", (Exception)((Object)messagingException));
        }
        return this.make(this.makeContentBodyPart(mimeMessage), string);
    }

    static {
        MailcapCommandMap mailcapCommandMap = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mailcapCommandMap.addMailcap("application/pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_mime");
        mailcapCommandMap.addMailcap("application/x-pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_mime");
        CommandMap.setDefaultCommandMap((CommandMap)mailcapCommandMap);
    }
}

