/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.CompressedDataPacket;
import org.bouncycastle.bcpg.CompressionAlgorithmTags;
import org.bouncycastle.bcpg.PacketTags;
import org.bouncycastle.openpgp.PGPException;

public class PGPCompressedData
implements CompressionAlgorithmTags,
PacketTags {
    CompressedDataPacket data;

    public PGPCompressedData(BCPGInputStream bCPGInputStream) throws IOException {
        this.data = (CompressedDataPacket)bCPGInputStream.readPacket();
    }

    public int getAlgorithm() {
        return this.data.getAlgorithm();
    }

    public InputStream getDataStream() throws PGPException {
        if (this.getAlgorithm() == 1) {
            return new InflaterInputStream(this.getInputStream(), new Inflater(true));
        }
        if (this.getAlgorithm() == 2) {
            return new InflaterInputStream(this.getInputStream());
        }
        throw new PGPException("can't recognise compression algorithm: " + this.getAlgorithm());
    }

    public InputStream getInputStream() {
        return this.data.getInputStream();
    }
}

