/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.Iterator;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.Packet;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.SignaturePacket;
import org.bouncycastle.bcpg.UserAttributePacket;
import org.bouncycastle.bcpg.UserIDPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;

public class PGPPublicKeyRing {
    ArrayList keys = new ArrayList();

    public PGPPublicKeyRing(byte[] byArray) throws IOException {
        this(new ByteArrayInputStream(byArray));
    }

    public PGPPublicKeyRing(InputStream inputStream) throws IOException {
        Object object;
        Packet packet;
        MessageDigest messageDigest;
        BCPGInputStream bCPGInputStream = inputStream instanceof BCPGInputStream ? (BCPGInputStream)inputStream : new BCPGInputStream(inputStream);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        try {
            messageDigest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("can't find SHA1 digest");
        }
        PublicKeyPacket publicKeyPacket = (PublicKeyPacket)bCPGInputStream.readPacket();
        while (bCPGInputStream.nextPacketTag() == 12) {
            bCPGInputStream.readPacket();
        }
        while (bCPGInputStream.nextPacketTag() == 13 || bCPGInputStream.nextPacketTag() == 17) {
            packet = bCPGInputStream.readPacket();
            if (packet instanceof UserIDPacket) {
                object = (UserIDPacket)packet;
                arrayList.add(((UserIDPacket)object).getID());
            } else {
                object = (UserAttributePacket)packet;
                arrayList.add(new PGPUserAttributeSubpacketVector(((UserAttributePacket)object).getSubpackets()));
            }
            object = new ArrayList();
            arrayList2.add(object);
            while (bCPGInputStream.nextPacketTag() == 2) {
                try {
                    ((ArrayList)object).add(new PGPSignature(bCPGInputStream));
                }
                catch (PGPException pGPException) {
                    throw new IOException("can't create signature object: " + pGPException.getMessage() + ", cause: " + pGPException.getUnderlyingException().toString());
                }
            }
        }
        while (bCPGInputStream.nextPacketTag() == 12) {
            bCPGInputStream.readPacket();
        }
        this.keys.add(new PGPPublicKey(publicKeyPacket, messageDigest, arrayList, arrayList2));
        while (bCPGInputStream.nextPacketTag() == 14) {
            packet = (PublicKeyPacket)bCPGInputStream.readPacket();
            object = (SignaturePacket)bCPGInputStream.readPacket();
            while (bCPGInputStream.nextPacketTag() == 12) {
                bCPGInputStream.readPacket();
            }
            this.keys.add(new PGPPublicKey((PublicKeyPacket)packet, messageDigest, (SignaturePacket)object));
        }
    }

    public PGPPublicKey getPublicKey() {
        return (PGPPublicKey)this.keys.get(0);
    }

    public PGPPublicKey getPublicKey(long l) throws PGPException, NoSuchProviderException {
        int n = 0;
        while (n != this.keys.size()) {
            PGPPublicKey pGPPublicKey = (PGPPublicKey)this.keys.get(n);
            if (l == pGPPublicKey.getKeyID()) {
                return pGPPublicKey;
            }
            ++n;
        }
        return null;
    }

    public Iterator getPublicKeys() {
        return this.keys.iterator();
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void encode(OutputStream outputStream) throws IOException {
        int n = 0;
        while (n != this.keys.size()) {
            PGPPublicKey pGPPublicKey = (PGPPublicKey)this.keys.get(n);
            pGPPublicKey.encode(outputStream);
            ++n;
        }
    }
}

