/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.KeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.bouncycastle.bcpg.BCPGKey;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.DSAPublicBCPGKey;
import org.bouncycastle.bcpg.ElGamalPublicBCPGKey;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.bcpg.PublicKeyAlgorithmTags;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.RSAPublicBCPGKey;
import org.bouncycastle.bcpg.SignaturePacket;
import org.bouncycastle.bcpg.UserAttributePacket;
import org.bouncycastle.bcpg.UserIDPacket;
import org.bouncycastle.jce.spec.ElGamalParameterSpec;
import org.bouncycastle.jce.spec.ElGamalPublicKeySpec;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;

public class PGPPublicKey
implements PublicKeyAlgorithmTags {
    private long keyID;
    private byte[] fingerprint;
    private int keyStrength;
    PublicKeyPacket publicPk;
    ArrayList ids = new ArrayList();
    ArrayList idSigs = new ArrayList();
    private SignaturePacket sig = null;

    private void init(MessageDigest messageDigest) throws IOException {
        BCPGKey bCPGKey = this.publicPk.getKey();
        if (this.publicPk.getVersion() <= 3) {
            RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)bCPGKey;
            this.keyID = rSAPublicBCPGKey.getModulus().longValue();
            messageDigest.update(new MPInteger(rSAPublicBCPGKey.getModulus()).getEncoded());
            messageDigest.update(new MPInteger(rSAPublicBCPGKey.getPublicExponent()).getEncoded());
            this.fingerprint = messageDigest.digest();
            this.keyStrength = rSAPublicBCPGKey.getModulus().bitLength();
        } else {
            byte[] byArray = this.publicPk.getEncodedContents();
            messageDigest.update((byte)-103);
            messageDigest.update((byte)(byArray.length >> 8));
            messageDigest.update((byte)byArray.length);
            messageDigest.update(byArray);
            this.fingerprint = messageDigest.digest();
            this.keyID = (long)(this.fingerprint[this.fingerprint.length - 8] & 0xFF) << 56 | (long)(this.fingerprint[this.fingerprint.length - 7] & 0xFF) << 48 | (long)(this.fingerprint[this.fingerprint.length - 6] & 0xFF) << 40 | (long)(this.fingerprint[this.fingerprint.length - 5] & 0xFF) << 32 | (long)(this.fingerprint[this.fingerprint.length - 4] & 0xFF) << 24 | (long)(this.fingerprint[this.fingerprint.length - 3] & 0xFF) << 16 | (long)(this.fingerprint[this.fingerprint.length - 2] & 0xFF) << 8 | (long)(this.fingerprint[this.fingerprint.length - 1] & 0xFF);
            if (bCPGKey instanceof RSAPublicBCPGKey) {
                this.keyStrength = ((RSAPublicBCPGKey)bCPGKey).getModulus().bitLength();
            } else if (bCPGKey instanceof DSAPublicBCPGKey) {
                this.keyStrength = ((DSAPublicBCPGKey)bCPGKey).getG().bitLength();
            } else if (bCPGKey instanceof ElGamalPublicBCPGKey) {
                this.keyStrength = ((ElGamalPublicBCPGKey)bCPGKey).getG().bitLength();
            }
        }
    }

    PGPPublicKey(PublicKeyPacket publicKeyPacket, MessageDigest messageDigest, SignaturePacket signaturePacket) throws IOException {
        this.publicPk = publicKeyPacket;
        this.sig = signaturePacket;
        this.init(messageDigest);
    }

    PGPPublicKey(PublicKeyPacket publicKeyPacket, MessageDigest messageDigest, ArrayList arrayList, ArrayList arrayList2) throws IOException {
        this.publicPk = publicKeyPacket;
        this.ids = arrayList;
        this.idSigs = arrayList2;
        this.init(messageDigest);
    }

    public int getVersion() {
        return this.publicPk.getVersion();
    }

    public Date getCreationTime() {
        return this.publicPk.getTime();
    }

    public int getValidDays() {
        return this.publicPk.getValidDays();
    }

    public long getKeyID() {
        return this.keyID;
    }

    public byte[] getFingerprint() {
        byte[] byArray = new byte[this.fingerprint.length];
        System.arraycopy(this.fingerprint, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public int getAlgorithm() {
        return this.publicPk.getAlgorithm();
    }

    public int getBitStrength() {
        return this.keyStrength;
    }

    public PublicKey getKey(String string) throws PGPException, NoSuchProviderException {
        try {
            switch (this.publicPk.getAlgorithm()) {
                case 1: 
                case 2: {
                    RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)this.publicPk.getKey();
                    RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(rSAPublicBCPGKey.getModulus(), rSAPublicBCPGKey.getPublicExponent());
                    KeyFactory keyFactory = KeyFactory.getInstance("RSA", string);
                    return keyFactory.generatePublic(rSAPublicKeySpec);
                }
                case 17: {
                    DSAPublicBCPGKey dSAPublicBCPGKey = (DSAPublicBCPGKey)this.publicPk.getKey();
                    DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(dSAPublicBCPGKey.getY(), dSAPublicBCPGKey.getP(), dSAPublicBCPGKey.getQ(), dSAPublicBCPGKey.getG());
                    KeyFactory keyFactory = KeyFactory.getInstance("DSA", string);
                    return keyFactory.generatePublic(dSAPublicKeySpec);
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elGamalPublicBCPGKey = (ElGamalPublicBCPGKey)this.publicPk.getKey();
                    ElGamalPublicKeySpec elGamalPublicKeySpec = new ElGamalPublicKeySpec(elGamalPublicBCPGKey.getY(), new ElGamalParameterSpec(elGamalPublicBCPGKey.getP(), elGamalPublicBCPGKey.getG()));
                    KeyFactory keyFactory = KeyFactory.getInstance("ElGamal", string);
                    return keyFactory.generatePublic((KeySpec)elGamalPublicKeySpec);
                }
            }
            throw new PGPException("unknown public key algorithm encountered");
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("exception constructing public key", exception);
        }
    }

    public Iterator getUserIDs() {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n != this.ids.size()) {
            if (this.ids.get(n) instanceof String) {
                arrayList.add(this.ids.get(n));
            }
            ++n;
        }
        return ((AbstractList)arrayList).iterator();
    }

    public Iterator getUserAttributes() {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n != this.ids.size()) {
            if (this.ids.get(n) instanceof PGPUserAttributeSubpacketVector) {
                arrayList.add(this.ids.get(n));
            }
            ++n;
        }
        return ((AbstractList)arrayList).iterator();
    }

    public Iterator getSignaturesForID(String string) {
        int n = 0;
        while (n != this.ids.size()) {
            if (string.equals(this.ids.get(n))) {
                return ((AbstractList)((ArrayList)this.idSigs.get(n))).iterator();
            }
            ++n;
        }
        return null;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void encode(OutputStream outputStream) throws IOException {
        BCPGOutputStream bCPGOutputStream = outputStream instanceof BCPGOutputStream ? (BCPGOutputStream)outputStream : new BCPGOutputStream(outputStream);
        bCPGOutputStream.writePacket(this.publicPk);
        if (this.sig == null) {
            int n = 0;
            while (n != this.ids.size()) {
                Object object;
                if (this.ids.get(n) instanceof String) {
                    object = (String)this.ids.get(n);
                    bCPGOutputStream.writePacket(new UserIDPacket((String)object));
                } else {
                    object = (PGPUserAttributeSubpacketVector)this.ids.get(n);
                    bCPGOutputStream.writePacket(new UserAttributePacket(((PGPUserAttributeSubpacketVector)object).toSubpacketArray()));
                }
                object = (ArrayList)this.idSigs.get(n);
                int n2 = 0;
                while (n2 != ((ArrayList)object).size()) {
                    ((PGPSignature)((ArrayList)object).get(n2)).encode(bCPGOutputStream);
                    ++n2;
                }
                ++n;
            }
        } else {
            this.sig.encode(bCPGOutputStream);
        }
    }
}

