/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.examples;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureList;

public class DetachedSignatureProcessor {
    private static void verifySignature(String string, InputStream inputStream, InputStream inputStream2, boolean bl) throws Exception {
        int n;
        if (bl) {
            inputStream = new ArmoredInputStream(inputStream);
        }
        PGPObjectFactory pGPObjectFactory = new PGPObjectFactory(inputStream);
        PGPCompressedData pGPCompressedData = (PGPCompressedData)pGPObjectFactory.nextObject();
        pGPObjectFactory = new PGPObjectFactory(pGPCompressedData.getDataStream());
        PGPPublicKeyRing pGPPublicKeyRing = new PGPPublicKeyRing(new BCPGInputStream(inputStream2));
        PGPPublicKey pGPPublicKey = pGPPublicKeyRing.getPublicKey();
        FileInputStream fileInputStream = new FileInputStream(string);
        PGPSignatureList pGPSignatureList = (PGPSignatureList)pGPObjectFactory.nextObject();
        PGPSignature pGPSignature = pGPSignatureList.get(0);
        pGPSignature.initVerify(pGPPublicKey, "BC");
        while ((n = ((InputStream)fileInputStream).read()) >= 0) {
            pGPSignature.update((byte)n);
        }
        if (pGPSignature.verify()) {
            System.out.println("signature verified.");
        } else {
            System.out.println("signature verification failed.");
        }
    }

    private static void createSignature(String string, InputStream inputStream, OutputStream outputStream, char[] cArray, boolean bl) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, PGPException, SignatureException {
        if (bl) {
            outputStream = new ArmoredOutputStream(outputStream);
        }
        PGPSecretKeyRing pGPSecretKeyRing = new PGPSecretKeyRing(new BCPGInputStream(inputStream));
        PGPPrivateKey pGPPrivateKey = pGPSecretKeyRing.getSecretKey().extractPrivateKey(cArray, "BC");
        PGPSignatureGenerator pGPSignatureGenerator = new PGPSignatureGenerator(1, 2, "BC");
        pGPSignatureGenerator.initSign(0, pGPPrivateKey);
        PGPCompressedDataGenerator pGPCompressedDataGenerator = new PGPCompressedDataGenerator(2);
        BCPGOutputStream bCPGOutputStream = new BCPGOutputStream(pGPCompressedDataGenerator.open(outputStream));
        FileInputStream fileInputStream = new FileInputStream(string);
        int n = 0;
        while ((n = fileInputStream.read()) >= 0) {
            pGPSignatureGenerator.update((byte)n);
        }
        pGPSignatureGenerator.generate().encode(bCPGOutputStream);
        pGPCompressedDataGenerator.close();
        outputStream.close();
    }

    public static void main(String[] stringArray) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (stringArray[0].equals("-s")) {
            if (stringArray[1].equals("-a")) {
                FileInputStream fileInputStream = new FileInputStream(stringArray[3]);
                FileOutputStream fileOutputStream = new FileOutputStream(stringArray[2] + ".asc");
                DetachedSignatureProcessor.createSignature(stringArray[2], fileInputStream, fileOutputStream, stringArray[4].toCharArray(), true);
            } else {
                FileInputStream fileInputStream = new FileInputStream(stringArray[2]);
                FileOutputStream fileOutputStream = new FileOutputStream(stringArray[1] + ".bpg");
                DetachedSignatureProcessor.createSignature(stringArray[1], fileInputStream, fileOutputStream, stringArray[3].toCharArray(), false);
            }
        } else if (stringArray[0].equals("-v")) {
            if (stringArray[1].equals("-a")) {
                FileInputStream fileInputStream = new FileInputStream(stringArray[3]);
                FileInputStream fileInputStream2 = new FileInputStream(stringArray[4]);
                DetachedSignatureProcessor.verifySignature(stringArray[2], fileInputStream, fileInputStream2, true);
            } else {
                FileInputStream fileInputStream = new FileInputStream(stringArray[2]);
                FileInputStream fileInputStream3 = new FileInputStream(stringArray[3]);
                DetachedSignatureProcessor.verifySignature(stringArray[1], fileInputStream, fileInputStream3, false);
            }
        } else {
            System.err.println("usage: ClearSignedFileProcessor [-s [-a] file keyfile passPhrase]|[-v [-a] file sigFile keyFile]");
        }
    }
}

