/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import java.security.SignatureException;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.OnePassSignaturePacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPUtil;

public class PGPOnePassSignature {
    private OnePassSignaturePacket sigPack;
    private Signature sig;

    PGPOnePassSignature(BCPGInputStream bCPGInputStream) throws IOException, PGPException {
        this((OnePassSignaturePacket)bCPGInputStream.readPacket());
    }

    PGPOnePassSignature(OnePassSignaturePacket onePassSignaturePacket) throws PGPException {
        this.sigPack = onePassSignaturePacket;
        try {
            this.sig = Signature.getInstance(PGPUtil.getSignatureName(onePassSignaturePacket.getKeyAlgorithm(), onePassSignaturePacket.getHashAlgorithm()), PGPUtil.getDefaultProvider());
        }
        catch (Exception exception) {
            throw new PGPException("can't set up signature object.", exception);
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        BCPGOutputStream bCPGOutputStream = outputStream instanceof BCPGOutputStream ? (BCPGOutputStream)outputStream : new BCPGOutputStream(outputStream);
        bCPGOutputStream.writePacket(this.sigPack);
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public long getKeyID() {
        return this.sigPack.getKeyID();
    }

    public void initVerify(PGPPublicKey pGPPublicKey, String string) throws NoSuchProviderException, PGPException {
        try {
            this.sig.initVerify(pGPPublicKey.getKey(string));
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PGPException("invalid key.", invalidKeyException);
        }
    }

    public void update(byte by) throws SignatureException {
        this.sig.update(by);
    }

    public void update(byte[] byArray) throws SignatureException {
        this.sig.update(byArray);
    }

    public void update(byte[] byArray, int n, int n2) throws SignatureException {
        this.sig.update(byArray, n, n2);
    }

    public boolean verify(PGPSignature pGPSignature) throws PGPException, SignatureException {
        this.sig.update(pGPSignature.getSignatureTrailer());
        return this.sig.verify(pGPSignature.getSignature());
    }
}

