/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.examples;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPUtil;

public class KeyBasedFileProcessor {
    private static PGPPublicKey readPublicKey(InputStream inputStream) throws IOException {
        PGPPublicKeyRing pGPPublicKeyRing = new PGPPublicKeyRing(inputStream);
        return pGPPublicKeyRing.getPublicKey();
    }

    private static PGPPrivateKey readSecretKey(InputStream inputStream, char[] cArray) throws IOException, PGPException, NoSuchProviderException {
        PGPSecretKeyRing pGPSecretKeyRing = new PGPSecretKeyRing(inputStream);
        return pGPSecretKeyRing.getSecretKey().extractPrivateKey(cArray, "BC");
    }

    private static void decryptFile(InputStream inputStream, PGPPrivateKey pGPPrivateKey, boolean bl) throws Exception {
        int n;
        if (bl) {
            inputStream = new ArmoredInputStream(inputStream);
        }
        PGPObjectFactory pGPObjectFactory = new PGPObjectFactory(inputStream);
        PGPEncryptedDataList pGPEncryptedDataList = (PGPEncryptedDataList)pGPObjectFactory.nextObject();
        PGPPublicKeyEncryptedData pGPPublicKeyEncryptedData = (PGPPublicKeyEncryptedData)pGPEncryptedDataList.get(0);
        InputStream inputStream2 = pGPPublicKeyEncryptedData.getDataStream(pGPPrivateKey, "BC");
        PGPObjectFactory pGPObjectFactory2 = new PGPObjectFactory(inputStream2);
        PGPCompressedData pGPCompressedData = (PGPCompressedData)pGPObjectFactory2.nextObject();
        pGPObjectFactory2 = new PGPObjectFactory(pGPCompressedData.getDataStream());
        PGPLiteralData pGPLiteralData = (PGPLiteralData)pGPObjectFactory2.nextObject();
        FileOutputStream fileOutputStream = new FileOutputStream(pGPLiteralData.getFileName());
        InputStream inputStream3 = pGPLiteralData.getInputStream();
        while ((n = inputStream3.read()) >= 0) {
            fileOutputStream.write(n);
        }
    }

    private static void encryptFile(OutputStream outputStream, String string, PGPPublicKey pGPPublicKey, boolean bl) throws IOException, NoSuchProviderException, PGPException {
        if (bl) {
            outputStream = new ArmoredOutputStream(outputStream);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PGPCompressedDataGenerator pGPCompressedDataGenerator = new PGPCompressedDataGenerator(1);
        PGPUtil.writeFileToLiteralData(pGPCompressedDataGenerator.open(byteArrayOutputStream), 'b', new File(string));
        pGPCompressedDataGenerator.close();
        PGPEncryptedDataGenerator pGPEncryptedDataGenerator = new PGPEncryptedDataGenerator(3, new SecureRandom(), "BC");
        pGPEncryptedDataGenerator.addMethod(pGPPublicKey);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        OutputStream outputStream2 = pGPEncryptedDataGenerator.open(outputStream, byArray.length);
        outputStream2.write(byArray);
        outputStream2.close();
    }

    public static void main(String[] stringArray) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (stringArray[0].equals("-e")) {
            if (stringArray[1].equals("-a")) {
                FileInputStream fileInputStream = new FileInputStream(stringArray[3]);
                FileOutputStream fileOutputStream = new FileOutputStream(stringArray[2] + ".asc");
                KeyBasedFileProcessor.encryptFile(fileOutputStream, stringArray[2], KeyBasedFileProcessor.readPublicKey(fileInputStream), true);
            } else {
                FileInputStream fileInputStream = new FileInputStream(stringArray[2]);
                FileOutputStream fileOutputStream = new FileOutputStream(stringArray[1] + ".bpg");
                KeyBasedFileProcessor.encryptFile(fileOutputStream, stringArray[1], KeyBasedFileProcessor.readPublicKey(fileInputStream), false);
            }
        } else if (stringArray[0].equals("-d")) {
            if (stringArray[1].equals("-a")) {
                FileInputStream fileInputStream = new FileInputStream(stringArray[3]);
                FileInputStream fileInputStream2 = new FileInputStream(stringArray[2]);
                KeyBasedFileProcessor.decryptFile(fileInputStream2, KeyBasedFileProcessor.readSecretKey(fileInputStream, stringArray[4].toCharArray()), true);
            } else {
                FileInputStream fileInputStream = new FileInputStream(stringArray[2]);
                FileInputStream fileInputStream3 = new FileInputStream(stringArray[1]);
                KeyBasedFileProcessor.decryptFile(fileInputStream3, KeyBasedFileProcessor.readSecretKey(fileInputStream, stringArray[3].toCharArray()), false);
            }
        } else {
            System.err.println("usage: KeyBasedFileProcessor -e|-d [-a] file passPhrase");
        }
    }
}

