package org.bouncycastle.asn1;

import java.io.IOException;

/**
 * Base class for an application specific object
 */
public class DERApplicationSpecific 
	extends DERObject
{
	private int		tag;
	private byte[]	octets;
	
	public DERApplicationSpecific(
		int		tag,
		byte[]	octets)
	{
		this.tag = tag;
		this.octets = octets;
	}
	
	public boolean isConstructed()
	{
		return (tag & DERTags.CONSTRUCTED) != 0;
	}
	
	public byte[] getContents()
	{
		return octets;
	}
	
    /* (non-Javadoc)
     * @see org.bouncycastle.asn1.DERObject#encode(org.bouncycastle.asn1.DEROutputStream)
     */
    void encode(DEROutputStream out) throws IOException
    {
        out.writeEncoded(DERTags.APPLICATION | tag, octets);
    }
}
