/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.bouncycastle.bcpg.CRC24;

public class ArmoredInputStream
extends InputStream {
    private static final byte[] decodingTable = new byte[128];
    InputStream in;
    boolean start = true;
    int[] outBuf = new int[3];
    int bufPtr = 3;
    CRC24 crc = new CRC24();
    boolean crcFound = false;
    boolean hasHeaders = true;
    String header = null;
    boolean newLineFound = false;
    boolean clearText = false;
    boolean restart = false;
    Vector headerList = new Vector();

    static {
        int n = 65;
        while (n <= 90) {
            ArmoredInputStream.decodingTable[n] = (byte)(n - 65);
            ++n;
        }
        int n2 = 97;
        while (n2 <= 122) {
            ArmoredInputStream.decodingTable[n2] = (byte)(n2 - 97 + 26);
            ++n2;
        }
        int n3 = 48;
        while (n3 <= 57) {
            ArmoredInputStream.decodingTable[n3] = (byte)(n3 - 48 + 52);
            ++n3;
        }
        ArmoredInputStream.decodingTable[43] = 62;
        ArmoredInputStream.decodingTable[47] = 63;
    }

    public ArmoredInputStream(InputStream inputStream) throws IOException {
        this.in = inputStream;
        if (this.hasHeaders) {
            this.parseHeaders();
        }
        this.start = false;
    }

    public ArmoredInputStream(InputStream inputStream, boolean bl) throws IOException {
        this.in = inputStream;
        this.hasHeaders = bl;
        if (bl) {
            this.parseHeaders();
        }
        this.start = false;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    private int decode(int n, int n2, int n3, int n4, int[] nArray) throws EOFException {
        if (n4 < 0) {
            throw new EOFException("unexpected end of file in armored stream.");
        }
        if (n3 == 61) {
            int n5 = decodingTable[n] & 0xFF;
            int n6 = decodingTable[n2] & 0xFF;
            nArray[2] = (n5 << 2 | n6 >> 4) & 0xFF;
            return 2;
        }
        if (n4 == 61) {
            byte by = decodingTable[n];
            byte by2 = decodingTable[n2];
            byte by3 = decodingTable[n3];
            nArray[1] = (by << 2 | by2 >> 4) & 0xFF;
            nArray[2] = (by2 << 4 | by3 >> 2) & 0xFF;
            return 1;
        }
        byte by = decodingTable[n];
        byte by4 = decodingTable[n2];
        byte by5 = decodingTable[n3];
        byte by6 = decodingTable[n4];
        nArray[0] = (by << 2 | by4 >> 4) & 0xFF;
        nArray[1] = (by4 << 4 | by5 >> 2) & 0xFF;
        nArray[2] = (by5 << 6 | by6) & 0xFF;
        return 0;
    }

    public String getArmorHeaderLine() {
        return this.header;
    }

    public String[] getArmorHeaders() {
        if (this.headerList.size() <= 1) {
            return null;
        }
        String[] stringArray = new String[this.headerList.size() - 1];
        int n = 0;
        while (n != stringArray.length) {
            stringArray[n] = (String)this.headerList.elementAt(n + 1);
            ++n;
        }
        return stringArray;
    }

    public boolean isClearText() {
        return this.clearText;
    }

    /*
     * Unable to fully structure code
     */
    private boolean parseHeaders() throws IOException {
        block6: {
            this.header = null;
            var2_1 = 0;
            var3_2 = false;
            this.headerList = new Vector<E>();
            if (!this.restart) ** GOTO lbl12
            var3_2 = true;
            break block6;
lbl-1000:
            // 1 sources

            {
                if (var1_3 == 45 && (var2_1 == 0 || var2_1 == 10)) {
                    var3_2 = true;
                    break;
                }
                var2_1 = var1_3;
lbl12:
                // 2 sources

                ** while ((var1_3 = this.in.read()) >= 0)
            }
        }
        if (var3_2) {
            var4_4 = new StringBuffer("-");
            if (this.restart) {
                var4_4.append('-');
            }
            while ((var1_3 = this.in.read()) >= 0) {
                if (var2_1 == 10 && var1_3 == 10) break;
                if (var1_3 == 13 || var1_3 == 10) {
                    this.headerList.addElement(var4_4.toString());
                    var4_4.setLength(0);
                }
                if (var1_3 == 13) continue;
                var2_1 = var1_3;
                if (var1_3 == 10) continue;
                var4_4.append((char)var2_1);
            }
        }
        this.header = (String)this.headerList.elementAt(0);
        this.clearText = this.header.equals("-----BEGIN PGP SIGNED MESSAGE-----");
        this.newLineFound = true;
        return var3_2;
    }

    public int read() throws IOException {
        int n;
        if (this.start) {
            if (this.hasHeaders) {
                this.parseHeaders();
            }
            this.start = false;
        }
        if (this.clearText) {
            int n2 = this.in.read();
            if (n2 == 10) {
                this.newLineFound = true;
            } else if (this.newLineFound && n2 == 45) {
                n2 = this.in.read();
                if (n2 == 45) {
                    this.clearText = false;
                    this.start = true;
                    this.restart = true;
                } else {
                    n2 = this.in.read();
                }
                this.newLineFound = false;
            } else {
                this.newLineFound = false;
            }
            return n2;
        }
        if (this.bufPtr > 2) {
            n = this.in.read();
            if (n == 10 || n == 13) {
                n = this.in.read();
                if (n == 10) {
                    n = this.in.read();
                }
                if (n < 0) {
                    return -1;
                }
                if (n == 61) {
                    this.bufPtr = this.decode(this.in.read(), this.in.read(), this.in.read(), this.in.read(), this.outBuf);
                    if (this.bufPtr == 0) {
                        int n3 = (this.outBuf[0] & 0xFF) << 16 | (this.outBuf[1] & 0xFF) << 8 | this.outBuf[2] & 0xFF;
                        this.crcFound = true;
                        if (n3 != this.crc.getValue()) {
                            throw new IOException("crc check failed in armored message.");
                        }
                        return -1;
                    }
                    throw new IOException("no crc found in armored message.");
                }
                if (n == 45) {
                    while ((n = this.in.read()) >= 0) {
                        if (n == 10) break;
                    }
                    if (!this.crcFound) {
                        throw new IOException("crc check not found.");
                    }
                    return -1;
                }
                this.bufPtr = this.decode(n, this.in.read(), this.in.read(), this.in.read(), this.outBuf);
            } else if (n >= 0) {
                this.bufPtr = this.decode(n, this.in.read(), this.in.read(), this.in.read(), this.outBuf);
            } else {
                return -1;
            }
        }
        n = this.outBuf[this.bufPtr++];
        this.crc.update(n);
        return n;
    }
}

