/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;

public class PGPSecretKeyRingCollection {
    private HashMap secretRings = new HashMap();
    private ArrayList order = new ArrayList();

    public PGPSecretKeyRingCollection(InputStream inputStream) throws IOException, PGPException {
        PGPObjectFactory pGPObjectFactory = new PGPObjectFactory(inputStream);
        PGPSecretKeyRing pGPSecretKeyRing = null;
        while ((pGPSecretKeyRing = (PGPSecretKeyRing)pGPObjectFactory.nextObject()) != null) {
            Long l = new Long(pGPSecretKeyRing.getPublicKey().getKeyID());
            this.secretRings.put(l, pGPSecretKeyRing);
            this.order.add(l);
        }
    }

    public PGPSecretKeyRingCollection(Collection collection) throws IOException, PGPException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            PGPSecretKeyRing pGPSecretKeyRing = (PGPSecretKeyRing)iterator.next();
            Long l = new Long(pGPSecretKeyRing.getPublicKey().getKeyID());
            this.secretRings.put(l, pGPSecretKeyRing);
            this.order.add(l);
        }
    }

    public PGPSecretKeyRingCollection(byte[] byArray) throws IOException, PGPException {
        this(new ByteArrayInputStream(byArray));
    }

    public void encode(OutputStream outputStream) throws IOException {
        BCPGOutputStream bCPGOutputStream = outputStream instanceof BCPGOutputStream ? (BCPGOutputStream)outputStream : new BCPGOutputStream(outputStream);
        Iterator iterator = ((AbstractList)this.order).iterator();
        while (iterator.hasNext()) {
            PGPSecretKeyRing pGPSecretKeyRing = (PGPSecretKeyRing)this.secretRings.get(iterator.next());
            pGPSecretKeyRing.encode(bCPGOutputStream);
        }
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public Iterator getKeyRings() {
        return this.secretRings.values().iterator();
    }

    public PGPSecretKey getSecretKey(long l) throws PGPException {
        Iterator iterator = this.getKeyRings();
        while (iterator.hasNext()) {
            PGPSecretKeyRing pGPSecretKeyRing = (PGPSecretKeyRing)iterator.next();
            PGPSecretKey pGPSecretKey = pGPSecretKeyRing.getSecretKey(l);
            if (pGPSecretKey == null) continue;
            return pGPSecretKey;
        }
        return null;
    }

    public PGPSecretKeyRing getSecretKeyRing(long l) throws PGPException {
        Long l2 = new Long(l);
        if (this.secretRings.containsKey(l2)) {
            return (PGPSecretKeyRing)this.secretRings.get(l2);
        }
        Iterator iterator = this.getKeyRings();
        while (iterator.hasNext()) {
            PGPSecretKeyRing pGPSecretKeyRing = (PGPSecretKeyRing)iterator.next();
            PGPSecretKey pGPSecretKey = pGPSecretKeyRing.getSecretKey(l);
            if (pGPSecretKey == null) continue;
            return pGPSecretKeyRing;
        }
        return null;
    }
}

