/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.macs.CBCBlockCipherMac;
import org.bouncycastle.crypto.macs.CFBBlockCipherMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class MacTest
implements Test {
    static byte[] keyBytes = Hex.decode((String)"0123456789abcdef");
    static byte[] ivBytes = Hex.decode((String)"1234567890abcdef");
    static byte[] input = Hex.decode((String)"37363534333231204e6f77206973207468652074696d6520666f7220");
    static byte[] output1 = Hex.decode((String)"f1d30f68");
    static byte[] output2 = Hex.decode((String)"58d2e77e");
    static byte[] output3 = Hex.decode((String)"cd647403");

    private boolean arraysEqual(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public TestResult perform() {
        KeyParameter keyParameter = new KeyParameter(keyBytes);
        DESEngine dESEngine = new DESEngine();
        CBCBlockCipherMac cBCBlockCipherMac = new CBCBlockCipherMac((BlockCipher)dESEngine);
        cBCBlockCipherMac.init((CipherParameters)keyParameter);
        cBCBlockCipherMac.update(input, 0, input.length);
        byte[] byArray = new byte[4];
        cBCBlockCipherMac.doFinal(byArray, 0);
        if (!this.arraysEqual(byArray, output1)) {
            return new SimpleTestResult(false, this.getName() + ": Failed - expected " + new String(Hex.encode((byte[])output1)) + " got " + new String(Hex.encode((byte[])byArray)));
        }
        ParametersWithIV parametersWithIV = new ParametersWithIV((CipherParameters)keyParameter, ivBytes);
        cBCBlockCipherMac.init((CipherParameters)parametersWithIV);
        cBCBlockCipherMac.update(input, 0, input.length);
        byArray = new byte[4];
        cBCBlockCipherMac.doFinal(byArray, 0);
        if (!this.arraysEqual(byArray, output2)) {
            return new SimpleTestResult(false, this.getName() + ": Failed - expected " + new String(Hex.encode((byte[])output2)) + " got " + new String(Hex.encode((byte[])byArray)));
        }
        parametersWithIV = new ParametersWithIV((CipherParameters)keyParameter, ivBytes);
        cBCBlockCipherMac = new CFBBlockCipherMac((BlockCipher)dESEngine);
        cBCBlockCipherMac.init((CipherParameters)parametersWithIV);
        cBCBlockCipherMac.update(input, 0, input.length);
        byArray = new byte[4];
        cBCBlockCipherMac.doFinal(byArray, 0);
        if (!this.arraysEqual(byArray, output3)) {
            return new SimpleTestResult(false, this.getName() + ": Failed - expected " + new String(Hex.encode((byte[])output3)) + " got " + new String(Hex.encode((byte[])byArray)));
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public String getName() {
        return "Mac";
    }

    public static void main(String[] stringArray) {
        MacTest macTest = new MacTest();
        TestResult testResult = macTest.perform();
        System.out.println(testResult);
    }
}

