/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;

public class DERApplicationSpecific
extends DERObject {
    private int tag;
    private byte[] octets;

    public DERApplicationSpecific(int n, DEREncodable dEREncodable) throws IOException {
        this.tag = n | 0x20;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        dEROutputStream.writeObject(dEREncodable);
        this.octets = byteArrayOutputStream.toByteArray();
    }

    public DERApplicationSpecific(int n, byte[] byArray) {
        this.tag = n;
        this.octets = byArray;
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(0x40 | this.tag, this.octets);
    }

    public int getApplicationTag() {
        return this.tag & 0x1F;
    }

    public byte[] getContents() {
        return this.octets;
    }

    public DERObject getObject() throws IOException {
        return new ASN1InputStream(new ByteArrayInputStream(this.getContents())).readObject();
    }

    public boolean isConstructed() {
        return (this.tag & 0x20) != 0;
    }
}

