/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;

public abstract class ECCurve {
    BigInteger q;
    ECFieldElement a;
    ECFieldElement b;

    public ECCurve(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        this.q = bigInteger;
        this.a = this.fromBigInteger(bigInteger2);
        this.b = this.fromBigInteger(bigInteger3);
    }

    public abstract ECPoint decodePoint(byte[] var1);

    public abstract ECFieldElement fromBigInteger(BigInteger var1);

    public ECFieldElement getA() {
        return this.a;
    }

    public ECFieldElement getB() {
        return this.b;
    }

    public static class Fp
    extends ECCurve {
        public Fp(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
            super(bigInteger, bigInteger2, bigInteger3);
        }

        public ECPoint decodePoint(byte[] byArray) {
            ECPoint.Fp fp = null;
            switch (byArray[0]) {
                case 2: 
                case 3: {
                    int n;
                    int n2 = byArray[0] & 1;
                    byte[] byArray2 = new byte[byArray.length - 1];
                    System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
                    ECFieldElement.Fp fp2 = new ECFieldElement.Fp(this.q, new BigInteger(1, byArray2));
                    ECFieldElement eCFieldElement = ((ECFieldElement)fp2).multiply(((ECFieldElement)fp2).square()).add(((ECFieldElement)fp2).multiply(this.a).add(this.b));
                    ECFieldElement eCFieldElement2 = eCFieldElement.sqrt();
                    if (eCFieldElement2 == null) {
                        throw new RuntimeException("Invalid point compression");
                    }
                    int n3 = n = eCFieldElement2.toBigInteger().testBit(0) ? 0 : 1;
                    if (n == n2) {
                        fp = new ECPoint.Fp(this, fp2, eCFieldElement2);
                        break;
                    }
                    fp = new ECPoint.Fp(this, fp2, new ECFieldElement.Fp(this.q, this.q.subtract(eCFieldElement2.toBigInteger())));
                    break;
                }
                case 4: {
                    byte[] byArray3 = new byte[(byArray.length - 1) / 2];
                    byte[] byArray4 = new byte[(byArray.length - 1) / 2];
                    System.arraycopy(byArray, 1, byArray3, 0, byArray3.length);
                    System.arraycopy(byArray, byArray3.length + 1, byArray4, 0, byArray4.length);
                    fp = new ECPoint.Fp(this, new ECFieldElement.Fp(this.q, new BigInteger(1, byArray3)), new ECFieldElement.Fp(this.q, new BigInteger(1, byArray4)));
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid point encoding 0x" + Integer.toString(byArray[0], 16));
                }
            }
            return fp;
        }

        public ECFieldElement fromBigInteger(BigInteger bigInteger) {
            return new ECFieldElement.Fp(this.q, bigInteger);
        }

        public BigInteger getQ() {
            return this.q;
        }
    }
}

