/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class SHA384DigestTest
implements Test {
    private static String testVec1 = "";
    private static String resVec1 = "38b060a751ac96384cd9327eb1b1e36a21fdb71114be07434c0cc7bf63f6e1da274edebfe76f65fbd51ad2f14898b95b";
    private static String testVec2 = "61";
    private static String resVec2 = "54a59b9f22b0b80880d8427e548b7c23abd873486e1f035dce9cd697e85175033caa88e6d57bc35efae0b5afd3145f31";
    private static String testVec3 = "616263";
    private static String resVec3 = "cb00753f45a35e8bb5a03d699ac65007272c32ab0eded1631a8b605a43ff5bed8086072ba1e7cc2358baeca134c825a7";
    private static String testVec4 = "61626364656667686263646566676869636465666768696a6465666768696a6b65666768696a6b6c666768696a6b6c6d6768696a6b6c6d6e68696a6b6c6d6e6f696a6b6c6d6e6f706a6b6c6d6e6f70716b6c6d6e6f7071726c6d6e6f707172736d6e6f70717273746e6f707172737475";
    private static String resVec4 = "09330c33f71147e83d192fc782cd1b4753111b173b3b05d22fa08086e3b0f712fcc7c71a557e2db966c3e9fa91746039";
    private static String testVec5 = "61616161616161616161";
    private static String resVec5 = "9d0e1809716474cb086e834e310a4a1ced149e9c00f248527972cec5704c2a5b07b8b3dc38ecc4ebae97ddd87f3d8985";

    public String getName() {
        return "SHA384";
    }

    public TestResult perform() {
        SHA384Digest sHA384Digest = new SHA384Digest();
        byte[] byArray = new byte[sHA384Digest.getDigestSize()];
        sHA384Digest.doFinal(byArray, 0);
        String string = new String(Hex.encode((byte[])byArray));
        if (!resVec1.equals(string)) {
            return new SimpleTestResult(false, "SHA-384 failing standard vector test 1" + System.getProperty("line.separator") + "    expected: " + resVec1 + System.getProperty("line.separator") + "    got     : " + string);
        }
        byte[] byArray2 = Hex.decode((String)testVec2);
        sHA384Digest.update(byArray2, 0, byArray2.length);
        sHA384Digest.doFinal(byArray, 0);
        string = new String(Hex.encode((byte[])byArray));
        if (!resVec2.equals(string)) {
            return new SimpleTestResult(false, "SHA-384 failing standard vector test 2" + System.getProperty("line.separator") + "    expected: " + resVec2 + System.getProperty("line.separator") + "    got     : " + string);
        }
        byArray2 = Hex.decode((String)testVec3);
        sHA384Digest.update(byArray2, 0, byArray2.length);
        sHA384Digest.doFinal(byArray, 0);
        string = new String(Hex.encode((byte[])byArray));
        if (!resVec3.equals(string)) {
            return new SimpleTestResult(false, "SHA-384 failing standard vector test 3" + System.getProperty("line.separator") + "    expected: " + resVec3 + System.getProperty("line.separator") + "    got     : " + string);
        }
        byArray2 = Hex.decode((String)testVec4);
        sHA384Digest.update(byArray2, 0, byArray2.length);
        sHA384Digest.doFinal(byArray, 0);
        string = new String(Hex.encode((byte[])byArray));
        if (!resVec4.equals(string)) {
            return new SimpleTestResult(false, "SHA-384 failing standard vector test 4" + System.getProperty("line.separator") + "    expected: " + resVec4 + System.getProperty("line.separator") + "    got     : " + string);
        }
        byArray2 = Hex.decode((String)testVec4);
        sHA384Digest.update(byArray2, 0, byArray2.length / 2);
        SHA384Digest sHA384Digest2 = new SHA384Digest(sHA384Digest);
        sHA384Digest.update(byArray2, byArray2.length / 2, byArray2.length - byArray2.length / 2);
        sHA384Digest.doFinal(byArray, 0);
        string = new String(Hex.encode((byte[])byArray));
        if (!resVec4.equals(string)) {
            return new SimpleTestResult(false, "SHA384 failing standard vector test 5" + System.getProperty("line.separator") + "    expected: " + resVec4 + System.getProperty("line.separator") + "    got     : " + string);
        }
        sHA384Digest2.update(byArray2, byArray2.length / 2, byArray2.length - byArray2.length / 2);
        sHA384Digest2.doFinal(byArray, 0);
        string = new String(Hex.encode((byte[])byArray));
        if (!resVec4.equals(string)) {
            return new SimpleTestResult(false, "SHA384 failing standard vector test 5" + System.getProperty("line.separator") + "    expected: " + resVec4 + System.getProperty("line.separator") + "    got     : " + string);
        }
        byArray2 = Hex.decode((String)testVec5);
        int n = 0;
        while (n < 100000) {
            sHA384Digest.update(byArray2, 0, byArray2.length);
            ++n;
        }
        sHA384Digest.doFinal(byArray, 0);
        string = new String(Hex.encode((byte[])byArray));
        if (!resVec5.equals(string)) {
            return new SimpleTestResult(false, "SHA-384 failing standard vector test 5" + System.getProperty("line.separator") + "    expected: " + resVec5 + System.getProperty("line.separator") + "    got     : " + string);
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] stringArray) {
        SHA384DigestTest sHA384DigestTest = new SHA384DigestTest();
        TestResult testResult = sHA384DigestTest.perform();
        System.out.println(testResult);
    }
}

