/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERString;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x509.X509NameTokenizer;

public class X509Name
implements DEREncodable {
    public static final DERObjectIdentifier C = new DERObjectIdentifier("2.5.4.6");
    public static final DERObjectIdentifier O = new DERObjectIdentifier("2.5.4.10");
    public static final DERObjectIdentifier OU = new DERObjectIdentifier("2.5.4.11");
    public static final DERObjectIdentifier T = new DERObjectIdentifier("2.5.4.12");
    public static final DERObjectIdentifier CN = new DERObjectIdentifier("2.5.4.3");
    public static final DERObjectIdentifier SN = new DERObjectIdentifier("2.5.4.5");
    public static final DERObjectIdentifier L = new DERObjectIdentifier("2.5.4.7");
    public static final DERObjectIdentifier ST = new DERObjectIdentifier("2.5.4.8");
    public static final DERObjectIdentifier SURNAME = new DERObjectIdentifier("2.5.4.4");
    public static final DERObjectIdentifier GIVENNAME = new DERObjectIdentifier("2.5.4.42");
    public static final DERObjectIdentifier INITIALS = new DERObjectIdentifier("2.5.4.43");
    public static final DERObjectIdentifier GENERATION = new DERObjectIdentifier("2.5.4.44");
    public static final DERObjectIdentifier EmailAddress;
    public static final DERObjectIdentifier E;
    public static final DERObjectIdentifier DC;
    public static final DERObjectIdentifier UID;
    public static Hashtable OIDLookUp;
    public static boolean DefaultReverse;
    public static Hashtable DefaultSymbols;
    public static Hashtable RFC2253Symbols;
    public static Hashtable SymbolLookUp;
    public static Hashtable DefaultLookUp;
    private Vector ordering = new Vector();
    private Vector values = new Vector();
    private Vector added = new Vector();
    private ASN1Sequence seq;

    static {
        E = EmailAddress = new DERObjectIdentifier("1.2.840.113549.1.9.1");
        DC = new DERObjectIdentifier("0.9.2342.19200300.100.1.25");
        UID = new DERObjectIdentifier("0.9.2342.19200300.100.1.1");
        OIDLookUp = new Hashtable();
        DefaultReverse = false;
        DefaultSymbols = OIDLookUp;
        RFC2253Symbols = new Hashtable();
        SymbolLookUp = new Hashtable();
        DefaultLookUp = SymbolLookUp;
        DefaultSymbols.put(C, "C");
        DefaultSymbols.put(O, "O");
        DefaultSymbols.put(T, "T");
        DefaultSymbols.put(OU, "OU");
        DefaultSymbols.put(CN, "CN");
        DefaultSymbols.put(L, "L");
        DefaultSymbols.put(ST, "ST");
        DefaultSymbols.put(SN, "SN");
        DefaultSymbols.put(EmailAddress, "E");
        DefaultSymbols.put(DC, "DC");
        DefaultSymbols.put(UID, "UID");
        DefaultSymbols.put(SURNAME, "SURNAME");
        DefaultSymbols.put(GIVENNAME, "GIVENNAME");
        DefaultSymbols.put(INITIALS, "INITIALS");
        DefaultSymbols.put(GENERATION, "GENERATION");
        RFC2253Symbols.put(C, "C");
        RFC2253Symbols.put(O, "O");
        RFC2253Symbols.put(T, "T");
        RFC2253Symbols.put(OU, "OU");
        RFC2253Symbols.put(CN, "CN");
        RFC2253Symbols.put(L, "L");
        RFC2253Symbols.put(ST, "ST");
        RFC2253Symbols.put(SN, "SN");
        RFC2253Symbols.put(EmailAddress, "EMAILADDRESS");
        RFC2253Symbols.put(DC, "DC");
        RFC2253Symbols.put(UID, "UID");
        RFC2253Symbols.put(SURNAME, "SURNAME");
        RFC2253Symbols.put(GIVENNAME, "GIVENNAME");
        RFC2253Symbols.put(INITIALS, "INITIALS");
        RFC2253Symbols.put(GENERATION, "GENERATION");
        DefaultLookUp.put("c", C);
        DefaultLookUp.put("o", O);
        DefaultLookUp.put("t", T);
        DefaultLookUp.put("ou", OU);
        DefaultLookUp.put("cn", CN);
        DefaultLookUp.put("l", L);
        DefaultLookUp.put("st", ST);
        DefaultLookUp.put("sn", SN);
        DefaultLookUp.put("emailaddress", E);
        DefaultLookUp.put("dc", DC);
        DefaultLookUp.put("e", E);
        DefaultLookUp.put("uid", UID);
        DefaultLookUp.put("surname", SURNAME);
        DefaultLookUp.put("givenname", GIVENNAME);
        DefaultLookUp.put("initials", INITIALS);
        DefaultLookUp.put("generation", GENERATION);
    }

    public X509Name(String string) {
        this(DefaultReverse, DefaultLookUp, string);
    }

    public X509Name(Hashtable hashtable) {
        this(null, hashtable);
    }

    public X509Name(Vector vector, Hashtable hashtable) {
        if (vector != null) {
            int n = 0;
            while (n != vector.size()) {
                this.ordering.addElement(vector.elementAt(n));
                this.added.addElement(Boolean.FALSE);
                ++n;
            }
        } else {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                this.ordering.addElement(enumeration.nextElement());
                this.added.addElement(Boolean.FALSE);
            }
        }
        int n = 0;
        while (n != this.ordering.size()) {
            DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)this.ordering.elementAt(n);
            if (hashtable.get(dERObjectIdentifier) == null) {
                throw new IllegalArgumentException("No attribute for object id - " + dERObjectIdentifier.getId() + " - passed to distinguished name");
            }
            this.values.addElement(hashtable.get(dERObjectIdentifier));
            ++n;
        }
    }

    public X509Name(Vector vector, Vector vector2) {
        if (vector.size() != vector2.size()) {
            throw new IllegalArgumentException("oids vector must be same length as values.");
        }
        int n = 0;
        while (n < vector.size()) {
            this.ordering.addElement(vector.elementAt(n));
            this.values.addElement(vector2.elementAt(n));
            this.added.addElement(Boolean.FALSE);
            ++n;
        }
    }

    public X509Name(ASN1Sequence aSN1Sequence) {
        this.seq = aSN1Sequence;
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            ASN1Set aSN1Set = (ASN1Set)enumeration.nextElement();
            int n = 0;
            while (n < aSN1Set.size()) {
                ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Set.getObjectAt(n);
                this.ordering.addElement(aSN1Sequence2.getObjectAt(0));
                this.values.addElement(((DERString)((Object)aSN1Sequence2.getObjectAt(1))).getString());
                this.added.addElement(n != 0 ? Boolean.TRUE : Boolean.FALSE);
                ++n;
            }
        }
    }

    public X509Name(boolean bl, String string) {
        this(bl, DefaultLookUp, string);
    }

    public X509Name(boolean bl, Hashtable hashtable, String string) {
        Object object;
        X509NameTokenizer x509NameTokenizer = new X509NameTokenizer(string);
        while (x509NameTokenizer.hasMoreTokens()) {
            object = x509NameTokenizer.nextToken();
            int n = ((String)object).indexOf(61);
            if (n == -1) {
                throw new IllegalArgumentException("badly formated directory string");
            }
            String string2 = ((String)object).substring(0, n);
            String string3 = ((String)object).substring(n + 1);
            DERObjectIdentifier dERObjectIdentifier = null;
            if (string2.toUpperCase().startsWith("OID.")) {
                dERObjectIdentifier = new DERObjectIdentifier(string2.substring(4));
            } else if (string2.charAt(0) >= '0' && string2.charAt(0) <= '9') {
                dERObjectIdentifier = new DERObjectIdentifier(string2);
            } else {
                dERObjectIdentifier = (DERObjectIdentifier)hashtable.get(string2.toLowerCase());
                if (dERObjectIdentifier == null) {
                    throw new IllegalArgumentException("Unknown object id - " + string2 + " - passed to distinguished name");
                }
            }
            this.ordering.addElement(dERObjectIdentifier);
            this.values.addElement(string3);
            this.added.addElement(Boolean.FALSE);
        }
        if (bl) {
            object = new Vector();
            Vector vector = new Vector();
            int n = this.ordering.size() - 1;
            while (n >= 0) {
                ((Vector)object).addElement(this.ordering.elementAt(n));
                vector.addElement(this.values.elementAt(n));
                this.added.addElement(Boolean.FALSE);
                --n;
            }
            this.ordering = object;
            this.values = vector;
        }
    }

    private void appendValue(StringBuffer stringBuffer, Hashtable hashtable, DERObjectIdentifier dERObjectIdentifier, String string) {
        String string2 = (String)hashtable.get(dERObjectIdentifier);
        if (string2 != null) {
            stringBuffer.append(string2);
        } else {
            stringBuffer.append(dERObjectIdentifier.getId());
        }
        stringBuffer.append("=");
        int n = stringBuffer.length();
        stringBuffer.append(string);
        int n2 = stringBuffer.length();
        while (n != n2) {
            if (stringBuffer.charAt(n) == ',' || stringBuffer.charAt(n) == '\"' || stringBuffer.charAt(n) == '\\' || stringBuffer.charAt(n) == '+' || stringBuffer.charAt(n) == '<' || stringBuffer.charAt(n) == '>' || stringBuffer.charAt(n) == ';') {
                stringBuffer.insert(n, "\\");
                ++n;
                ++n2;
            }
            ++n;
        }
    }

    private boolean canBePrintable(String string) {
        int n = string.length() - 1;
        while (n >= 0) {
            if (string.charAt(n) > '\u007f') {
                return false;
            }
            --n;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof X509Name)) {
            return false;
        }
        X509Name x509Name = (X509Name)object;
        if (this.getDERObject().equals(x509Name.getDERObject())) {
            return true;
        }
        int n = this.ordering.size();
        if (n != x509Name.ordering.size()) {
            return false;
        }
        boolean[] blArray = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            boolean bl = false;
            String string = ((DERObjectIdentifier)this.ordering.elementAt(n2)).getId();
            String string2 = (String)this.values.elementAt(n2);
            int n3 = 0;
            while (n3 < n) {
                if (!blArray[n3]) {
                    String string3 = ((DERObjectIdentifier)x509Name.ordering.elementAt(n3)).getId();
                    String string4 = (String)x509Name.values.elementAt(n3);
                    if (string.equals(string3)) {
                        char c;
                        int n4;
                        char c2;
                        if ((string2 = string2.trim().toLowerCase()).equals(string4 = string4.trim().toLowerCase())) {
                            blArray[n3] = true;
                            bl = true;
                            break;
                        }
                        StringBuffer stringBuffer = new StringBuffer();
                        StringBuffer stringBuffer2 = new StringBuffer();
                        if (string2.length() != 0) {
                            c2 = string2.charAt(0);
                            stringBuffer.append(c2);
                            n4 = 1;
                            while (n4 < string2.length()) {
                                c = string2.charAt(n4);
                                if (c2 != ' ' || c != ' ') {
                                    stringBuffer.append(c);
                                }
                                c2 = c;
                                ++n4;
                            }
                        }
                        if (string4.length() != 0) {
                            c2 = string4.charAt(0);
                            stringBuffer2.append(c2);
                            n4 = 1;
                            while (n4 < string4.length()) {
                                c = string4.charAt(n4);
                                if (c2 != ' ' || c != ' ') {
                                    stringBuffer2.append(c);
                                }
                                c2 = c;
                                ++n4;
                            }
                        }
                        if (stringBuffer.toString().equals(stringBuffer2.toString())) {
                            blArray[n3] = true;
                            bl = true;
                            break;
                        }
                    }
                }
                ++n3;
            }
            if (!bl) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean equals(Object object, boolean bl) {
        if (object == this) {
            return true;
        }
        if (!bl) {
            return this.equals(object);
        }
        if (object == null || !(object instanceof X509Name)) {
            return false;
        }
        X509Name x509Name = (X509Name)object;
        int n = this.ordering.size();
        if (n != x509Name.ordering.size()) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            String string = ((DERObjectIdentifier)this.ordering.elementAt(n2)).getId();
            String string2 = (String)this.values.elementAt(n2);
            String string3 = ((DERObjectIdentifier)x509Name.ordering.elementAt(n2)).getId();
            String string4 = (String)x509Name.values.elementAt(n2);
            if (string.equals(string3) && !(string2 = string2.trim().toLowerCase()).equals(string4 = string4.trim().toLowerCase())) {
                char c;
                int n3;
                char c2;
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                if (string2.length() != 0) {
                    c2 = string2.charAt(0);
                    stringBuffer.append(c2);
                    n3 = 1;
                    while (n3 < string2.length()) {
                        c = string2.charAt(n3);
                        if (c2 != ' ' || c != ' ') {
                            stringBuffer.append(c);
                        }
                        c2 = c;
                        ++n3;
                    }
                }
                if (string4.length() != 0) {
                    c2 = string4.charAt(0);
                    stringBuffer2.append(c2);
                    n3 = 1;
                    while (n3 < string4.length()) {
                        c = string4.charAt(n3);
                        if (c2 != ' ' || c != ' ') {
                            stringBuffer2.append(c);
                        }
                        c2 = c;
                        ++n3;
                    }
                }
                if (!stringBuffer.toString().equals(stringBuffer2.toString())) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    public DERObject getDERObject() {
        if (this.seq == null) {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            int n = 0;
            while (n != this.ordering.size()) {
                ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
                DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)this.ordering.elementAt(n);
                aSN1EncodableVector2.add(dERObjectIdentifier);
                String string = (String)this.values.elementAt(n);
                if (dERObjectIdentifier.equals(EmailAddress)) {
                    aSN1EncodableVector2.add(new DERIA5String(string));
                } else if (this.canBePrintable(string)) {
                    aSN1EncodableVector2.add(new DERPrintableString(string));
                } else {
                    aSN1EncodableVector2.add(new DERUTF8String(string));
                }
                aSN1EncodableVector.add(new DERSet(new DERSequence(aSN1EncodableVector2)));
                ++n;
            }
            this.seq = new DERSequence(aSN1EncodableVector);
        }
        return this.seq;
    }

    public static X509Name getInstance(Object object) {
        if (object == null || object instanceof X509Name) {
            return (X509Name)object;
        }
        if (object instanceof ASN1Sequence) {
            return new X509Name((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public static X509Name getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return X509Name.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public Vector getOIDs() {
        Vector vector = new Vector();
        int n = 0;
        while (n != this.ordering.size()) {
            vector.addElement(this.ordering.elementAt(n));
            ++n;
        }
        return vector;
    }

    public Vector getValues() {
        Vector vector = new Vector();
        int n = 0;
        while (n != this.values.size()) {
            vector.addElement(this.values.elementAt(n));
            ++n;
        }
        return vector;
    }

    public int hashCode() {
        ASN1Sequence aSN1Sequence = (ASN1Sequence)this.getDERObject();
        Enumeration enumeration = aSN1Sequence.getObjects();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            n ^= enumeration.nextElement().hashCode();
        }
        return n;
    }

    public String toString() {
        return this.toString(DefaultReverse, DefaultSymbols);
    }

    public String toString(boolean bl, Hashtable hashtable) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = true;
        if (bl) {
            int n = this.ordering.size() - 1;
            while (n >= 0) {
                if (bl2) {
                    bl2 = false;
                } else if (((Boolean)this.added.elementAt(n + 1)).booleanValue()) {
                    stringBuffer.append(" + ");
                } else {
                    stringBuffer.append(",");
                }
                this.appendValue(stringBuffer, hashtable, (DERObjectIdentifier)this.ordering.elementAt(n), (String)this.values.elementAt(n));
                --n;
            }
        } else {
            int n = 0;
            while (n < this.ordering.size()) {
                if (bl2) {
                    bl2 = false;
                } else if (((Boolean)this.added.elementAt(n)).booleanValue()) {
                    stringBuffer.append(" + ");
                } else {
                    stringBuffer.append(",");
                }
                this.appendValue(stringBuffer, hashtable, (DERObjectIdentifier)this.ordering.elementAt(n), (String)this.values.elementAt(n));
                ++n;
            }
        }
        return stringBuffer.toString();
    }
}

