/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAKey;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.crypto.DSA;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.DSASigner;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.jce.interfaces.ECKey;
import org.bouncycastle.jce.provider.DSAUtil;
import org.bouncycastle.jce.provider.ECUtil;
import org.bouncycastle.jce.provider.JDKKeyFactory;

public class JDKDSASigner
extends Signature
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers {
    private Digest digest;
    private DSA signer;
    private SecureRandom random;

    protected JDKDSASigner(String string, Digest digest, DSA dSA) {
        super(string);
        this.digest = digest;
        this.signer = dSA;
    }

    private BigInteger[] derDecode(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DERInputStream dERInputStream = new DERInputStream(byteArrayInputStream);
        ASN1Sequence aSN1Sequence = (ASN1Sequence)dERInputStream.readObject();
        BigInteger[] bigIntegerArray = new BigInteger[]{((DERInteger)aSN1Sequence.getObjectAt(0)).getValue(), ((DERInteger)aSN1Sequence.getObjectAt(1)).getValue()};
        return bigIntegerArray;
    }

    private byte[] derEncode(BigInteger bigInteger, BigInteger bigInteger2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new DERInteger(bigInteger));
        aSN1EncodableVector.add(new DERInteger(bigInteger2));
        dEROutputStream.writeObject(new DERSequence(aSN1EncodableVector));
        return byteArrayOutputStream.toByteArray();
    }

    protected Object engineGetParameter(String string) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        AsymmetricKeyParameter asymmetricKeyParameter = null;
        asymmetricKeyParameter = privateKey instanceof ECKey ? ECUtil.generatePrivateKeyParameter(privateKey) : DSAUtil.generatePrivateKeyParameter(privateKey);
        this.digest.reset();
        if (this.random != null) {
            this.signer.init(true, new ParametersWithRandom(asymmetricKeyParameter, this.random));
        } else {
            this.signer.init(true, asymmetricKeyParameter);
        }
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.random = secureRandom;
        this.engineInitSign(privateKey);
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        AsymmetricKeyParameter asymmetricKeyParameter;
        block8: {
            asymmetricKeyParameter = null;
            if (publicKey instanceof ECKey) {
                asymmetricKeyParameter = ECUtil.generatePublicKeyParameter(publicKey);
            } else if (publicKey instanceof DSAKey) {
                asymmetricKeyParameter = DSAUtil.generatePublicKeyParameter(publicKey);
            } else {
                try {
                    byte[] byArray = publicKey.getEncoded();
                    publicKey = JDKKeyFactory.createPublicKeyFromDERStream(new ByteArrayInputStream(byArray));
                    if (publicKey instanceof ECKey) {
                        asymmetricKeyParameter = ECUtil.generatePublicKeyParameter(publicKey);
                        break block8;
                    }
                    if (publicKey instanceof DSAKey) {
                        asymmetricKeyParameter = DSAUtil.generatePublicKeyParameter(publicKey);
                        break block8;
                    }
                    throw new InvalidKeyException("can't recognise key type in DSA based signer");
                }
                catch (Exception exception) {
                    throw new InvalidKeyException("can't recognise key type in DSA based signer");
                }
            }
        }
        this.digest.reset();
        this.signer.init(false, asymmetricKeyParameter);
    }

    protected void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] byArray = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray, 0);
        try {
            BigInteger[] bigIntegerArray = this.signer.generateSignature(byArray);
            return this.derEncode(bigIntegerArray[0], bigIntegerArray[1]);
        }
        catch (Exception exception) {
            throw new SignatureException(exception.toString());
        }
    }

    protected void engineUpdate(byte by) throws SignatureException {
        this.digest.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.digest.update(byArray, n, n2);
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        BigInteger[] bigIntegerArray;
        byte[] byArray2 = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray2, 0);
        try {
            bigIntegerArray = this.derDecode(byArray);
        }
        catch (Exception exception) {
            throw new SignatureException("error decoding signature bytes.");
        }
        return this.signer.verifySignature(byArray2, bigIntegerArray[0], bigIntegerArray[1]);
    }

    public static class stdDSA
    extends JDKDSASigner {
        public stdDSA() {
            super("SHA1withDSA", new SHA1Digest(), new DSASigner());
        }
    }

    public static class ecDSA
    extends JDKDSASigner {
        public ecDSA() {
            super("SHA1withECDSA", new SHA1Digest(), new ECDSASigner());
        }
    }
}

