/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class BlockCipherVectorTest
implements Test {
    int id;
    BlockCipher engine;
    CipherParameters param;
    byte[] input;
    byte[] output;

    public BlockCipherVectorTest(int n, BlockCipher blockCipher, CipherParameters cipherParameters, String string, String string2) {
        this.id = n;
        this.engine = blockCipher;
        this.param = cipherParameters;
        this.input = Hex.decode((String)string);
        this.output = Hex.decode((String)string2);
    }

    public String getName() {
        return this.engine.getAlgorithmName() + " Vector Test " + this.id;
    }

    public TestResult perform() {
        BufferedBlockCipher bufferedBlockCipher = new BufferedBlockCipher(this.engine);
        bufferedBlockCipher.init(true, this.param);
        byte[] byArray = new byte[this.input.length];
        int n = bufferedBlockCipher.processBytes(this.input, 0, this.input.length, byArray, 0);
        try {
            bufferedBlockCipher.doFinal(byArray, n);
        }
        catch (CryptoException cryptoException) {
            return new SimpleTestResult(false, this.getName() + ": failed - exception " + cryptoException.toString());
        }
        if (!this.isEqualArray(byArray, this.output)) {
            return new SimpleTestResult(false, this.getName() + ": failed - " + "expected " + new String(Hex.encode((byte[])this.output)) + " got " + new String(Hex.encode((byte[])byArray)));
        }
        bufferedBlockCipher.init(false, this.param);
        int n2 = bufferedBlockCipher.processBytes(this.output, 0, this.output.length, byArray, 0);
        try {
            bufferedBlockCipher.doFinal(byArray, n2);
        }
        catch (CryptoException cryptoException) {
            return new SimpleTestResult(false, this.getName() + ": failed reversal - exception " + cryptoException.toString());
        }
        if (!this.isEqualArray(this.input, byArray)) {
            return new SimpleTestResult(false, this.getName() + ": failed reversal got " + new String(Hex.encode((byte[])byArray)));
        }
        return new SimpleTestResult(true, this.getName() + ": OKAY");
    }

    private boolean isEqualArray(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n != byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

