/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGObject;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.DSAPublicBCPGKey;
import org.bouncycastle.bcpg.DSASecretBCPGKey;
import org.bouncycastle.bcpg.ElGamalPublicBCPGKey;
import org.bouncycastle.bcpg.ElGamalSecretBCPGKey;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.RSAPublicBCPGKey;
import org.bouncycastle.bcpg.RSASecretBCPGKey;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.SecretKeyPacket;
import org.bouncycastle.bcpg.TrustPacket;
import org.bouncycastle.bcpg.UserAttributePacket;
import org.bouncycastle.bcpg.UserIDPacket;
import org.bouncycastle.jce.interfaces.ElGamalPrivateKey;
import org.bouncycastle.jce.interfaces.ElGamalPublicKey;
import org.bouncycastle.jce.spec.ElGamalParameterSpec;
import org.bouncycastle.jce.spec.ElGamalPrivateKeySpec;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.bouncycastle.openpgp.PGPUtil;

public class PGPSecretKey {
    private long keyID;
    private byte[] fingerPrint;
    SecretKeyPacket secret;
    TrustPacket trust;
    ArrayList ids;
    ArrayList idTrusts;
    ArrayList idSigs;
    PGPPublicKey pub;
    ArrayList subSigs = null;

    PGPSecretKey(SecretKeyPacket secretKeyPacket, TrustPacket trustPacket, MessageDigest messageDigest, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) throws IOException {
        this.secret = secretKeyPacket;
        this.trust = trustPacket;
        this.ids = arrayList;
        this.idTrusts = arrayList2;
        this.idSigs = arrayList3;
        this.pub = new PGPPublicKey(secretKeyPacket.getPublicKeyPacket(), trustPacket, messageDigest, arrayList, null, arrayList3);
    }

    PGPSecretKey(SecretKeyPacket secretKeyPacket, TrustPacket trustPacket, MessageDigest messageDigest, ArrayList arrayList) throws IOException {
        this.secret = secretKeyPacket;
        this.trust = trustPacket;
        this.subSigs = arrayList;
        this.pub = new PGPPublicKey(secretKeyPacket.getPublicKeyPacket(), trustPacket, messageDigest, this.ids, null, this.idSigs);
    }

    public PGPSecretKey(int n, int n2, PublicKey publicKey, PrivateKey privateKey, Date date, String string, int n3, char[] cArray, PGPSignatureSubpacketVector pGPSignatureSubpacketVector, PGPSignatureSubpacketVector pGPSignatureSubpacketVector2, SecureRandom secureRandom, String string2) throws PGPException, NoSuchProviderException {
        Object object;
        BCPGObject bCPGObject;
        PublicKeyPacket publicKeyPacket;
        Object object2;
        Object object3;
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PGPException("can't find SHA1 digest");
        }
        if (publicKey instanceof RSAPublicKey) {
            object3 = (RSAPublicKey)publicKey;
            object2 = (RSAPrivateCrtKey)privateKey;
            publicKeyPacket = new PublicKeyPacket(n2, date, new RSAPublicBCPGKey(object3.getModulus(), object3.getPublicExponent()));
            bCPGObject = new RSASecretBCPGKey(object2.getPrivateExponent(), object2.getPrimeP(), object2.getPrimeQ());
        } else if (publicKey instanceof DSAPublicKey) {
            object3 = (DSAPublicKey)publicKey;
            object2 = object3.getParams();
            object = (DSAPrivateKey)privateKey;
            publicKeyPacket = new PublicKeyPacket(n2, date, new DSAPublicBCPGKey(object2.getP(), object2.getQ(), object2.getG(), object3.getY()));
            bCPGObject = new DSASecretBCPGKey(object.getX());
        } else if (publicKey instanceof ElGamalPublicKey) {
            object3 = (ElGamalPublicKey)publicKey;
            object2 = object3.getParams();
            object = (ElGamalPrivateKey)privateKey;
            publicKeyPacket = new PublicKeyPacket(n2, date, new ElGamalPublicBCPGKey(object2.getP(), object2.getG(), object3.getY()));
            bCPGObject = new ElGamalSecretBCPGKey(object.getX());
        } else {
            throw new PGPException("unknown key class");
        }
        object3 = PGPUtil.getSymmetricCipherName(n3);
        if (object3 == null) {
            throw new PGPException("null cipher specified");
        }
        object2 = null;
        try {
            object2 = Cipher.getInstance((String)object3 + "/CFB/NoPadding", string2);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw noSuchProviderException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception creating cipher", exception);
        }
        object = new byte[8];
        secureRandom.nextBytes((byte[])object);
        S2K s2K = new S2K(2, (byte[])object, 96);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BCPGOutputStream bCPGOutputStream = new BCPGOutputStream(byteArrayOutputStream);
            SecretKey secretKey = PGPUtil.makeKeyFromPassPhrase(n3, s2K, cArray, string2);
            ((Cipher)object2).init(1, (Key)secretKey, secureRandom);
            object = ((Cipher)object2).getIV();
            bCPGOutputStream.writeObject(bCPGObject);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            int n4 = 0;
            int n5 = 0;
            while (n5 != byArray.length) {
                n4 += byArray[n5] & 0xFF;
                ++n5;
            }
            bCPGOutputStream.write(n4 >> 8);
            bCPGOutputStream.write(n4);
            byte[] byArray2 = ((Cipher)object2).doFinal(byteArrayOutputStream.toByteArray());
            this.secret = new SecretKeyPacket(publicKeyPacket, n3, s2K, (byte[])object, byArray2);
            this.trust = null;
            this.ids = new ArrayList();
            this.ids.add(string);
            this.idTrusts = new ArrayList();
            this.idTrusts.add(null);
            this.idSigs = new ArrayList();
            this.pub = new PGPPublicKey(publicKeyPacket, this.trust, messageDigest, this.ids, this.idTrusts, this.idSigs);
            PGPSignatureGenerator pGPSignatureGenerator = new PGPSignatureGenerator(publicKeyPacket.getAlgorithm(), 2, string2);
            pGPSignatureGenerator.initSign(n, new PGPPrivateKey(privateKey, this.pub.getKeyID()));
            pGPSignatureGenerator.setHashedSubpackets(pGPSignatureSubpacketVector);
            pGPSignatureGenerator.setUnhashedSubpackets(pGPSignatureSubpacketVector2);
            ArrayList<PGPSignature> arrayList = new ArrayList<PGPSignature>();
            arrayList.add(pGPSignatureGenerator.generateCertification(string, this.pub));
            this.idSigs.add(arrayList);
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception encrypting key", exception);
        }
    }

    public boolean isSigningKey() {
        int n = this.secret.getEncAlgorithm();
        return n == 1 || n == 3 || n == 17 || n == 19;
    }

    public boolean isMasterKey() {
        return this.subSigs == null;
    }

    public long getKeyID() {
        return this.pub.getKeyID();
    }

    public PGPPublicKey getPublicKey() {
        return this.pub;
    }

    public Iterator getUserIDs() {
        return this.pub.getUserIDs();
    }

    public Iterator getUserAttributes() {
        return this.pub.getUserAttributes();
    }

    public PGPPrivateKey extractPrivateKey(char[] cArray, String string) throws PGPException, NoSuchProviderException {
        PublicKeyPacket publicKeyPacket = this.secret.getPublicKeyPacket();
        Object var4_4 = null;
        String string2 = PGPUtil.getSymmetricCipherName(this.secret.getEncAlgorithm());
        Cipher cipher = null;
        if (string2 != null) {
            try {
                cipher = Cipher.getInstance(string2 + "/CFB/NoPadding", string);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw noSuchProviderException;
            }
            catch (Exception exception) {
                throw new PGPException("Exception creating cipher", exception);
            }
        }
        byte[] byArray = this.secret.getSecretKeyData();
        byte[] byArray2 = null;
        try {
            Object object;
            Object object2;
            block22: {
                if (cipher != null) {
                    try {
                        if (this.secret.getPublicKeyPacket().getVersion() == 4) {
                            object2 = new IvParameterSpec(this.secret.getIV());
                            object = PGPUtil.makeKeyFromPassPhrase(this.secret.getEncAlgorithm(), this.secret.getS2K(), cArray, string);
                            cipher.init(2, (Key)object, (AlgorithmParameterSpec)object2);
                            byArray2 = cipher.doFinal(byArray, 0, byArray.length);
                        } else {
                            int n;
                            object2 = PGPUtil.makeKeyFromPassPhrase(this.secret.getEncAlgorithm(), this.secret.getS2K(), cArray, string);
                            byArray2 = new byte[byArray.length];
                            object = new byte[this.secret.getIV().length];
                            System.arraycopy(this.secret.getIV(), 0, object, 0, ((Object)object).length);
                            int n2 = 0;
                            int n3 = 0;
                            while (n3 != 4) {
                                cipher.init(2, (Key)object2, new IvParameterSpec((byte[])object));
                                n = ((byArray[n2] << 8 | byArray[n2 + 1] & 0xFF) + 7) / 8;
                                byArray2[n2] = byArray[n2];
                                byArray2[n2 + 1] = byArray[n2 + 1];
                                cipher.doFinal(byArray, n2 + 2, n, byArray2, n2 + 2);
                                n2 += 2 + n;
                                if (n3 != 3) {
                                    System.arraycopy(byArray, n2 - ((Object)object).length, object, 0, ((Object)object).length);
                                }
                                ++n3;
                            }
                            n = byArray[n2] << 8 & 0xFF00 | byArray[n2 + 1] & 0xFF;
                            int n4 = 0;
                            int n5 = 0;
                            while (n5 < byArray2.length - 2) {
                                n4 += byArray2[n5] & 0xFF;
                                ++n5;
                            }
                            if ((n4 &= 0xFFFF) != n) {
                                throw new PGPException("checksum mismatch: passphrase wrong, expected " + Integer.toHexString(n) + " found " + Integer.toHexString(n4));
                            }
                        }
                        break block22;
                    }
                    catch (PGPException pGPException) {
                        throw pGPException;
                    }
                    catch (Exception exception) {
                        throw new PGPException("Exception decrypting key", exception);
                    }
                }
                byArray2 = byArray;
            }
            object = new BCPGInputStream(new ByteArrayInputStream(byArray2));
            switch (publicKeyPacket.getAlgorithm()) {
                case 1: 
                case 2: {
                    RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)publicKeyPacket.getKey();
                    RSASecretBCPGKey rSASecretBCPGKey = new RSASecretBCPGKey((BCPGInputStream)object);
                    RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(rSASecretBCPGKey.getModulus(), rSAPublicBCPGKey.getPublicExponent(), rSASecretBCPGKey.getPrivateExponent(), rSASecretBCPGKey.getPrimeP(), rSASecretBCPGKey.getPrimeQ(), rSASecretBCPGKey.getPrimeExponentP(), rSASecretBCPGKey.getPrimeExponentQ(), rSASecretBCPGKey.getCrtCoefficient());
                    object2 = KeyFactory.getInstance("RSA", string);
                    return new PGPPrivateKey(((KeyFactory)object2).generatePrivate(rSAPrivateCrtKeySpec), this.getKeyID());
                }
                case 17: {
                    DSAPublicBCPGKey dSAPublicBCPGKey = (DSAPublicBCPGKey)publicKeyPacket.getKey();
                    DSASecretBCPGKey dSASecretBCPGKey = new DSASecretBCPGKey((BCPGInputStream)object);
                    DSAPrivateKeySpec dSAPrivateKeySpec = new DSAPrivateKeySpec(dSASecretBCPGKey.getX(), dSAPublicBCPGKey.getP(), dSAPublicBCPGKey.getQ(), dSAPublicBCPGKey.getG());
                    object2 = KeyFactory.getInstance("DSA", string);
                    return new PGPPrivateKey(((KeyFactory)object2).generatePrivate(dSAPrivateKeySpec), this.getKeyID());
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elGamalPublicBCPGKey = (ElGamalPublicBCPGKey)publicKeyPacket.getKey();
                    ElGamalSecretBCPGKey elGamalSecretBCPGKey = new ElGamalSecretBCPGKey((BCPGInputStream)object);
                    ElGamalPrivateKeySpec elGamalPrivateKeySpec = new ElGamalPrivateKeySpec(elGamalSecretBCPGKey.getX(), new ElGamalParameterSpec(elGamalPublicBCPGKey.getP(), elGamalPublicBCPGKey.getG()));
                    object2 = KeyFactory.getInstance("ElGamal", string);
                    return new PGPPrivateKey(((KeyFactory)object2).generatePrivate((KeySpec)elGamalPrivateKeySpec), this.getKeyID());
                }
            }
            throw new PGPException("unknown public key algorithm encountered");
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception constructing key", exception);
        }
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void encode(OutputStream outputStream) throws IOException {
        BCPGOutputStream bCPGOutputStream = outputStream instanceof BCPGOutputStream ? (BCPGOutputStream)outputStream : new BCPGOutputStream(outputStream);
        bCPGOutputStream.writePacket(this.secret);
        if (this.trust != null) {
            bCPGOutputStream.writePacket(this.trust);
        }
        if (this.subSigs == null) {
            int n = 0;
            while (n != this.ids.size()) {
                Object object;
                if (this.ids.get(n) instanceof String) {
                    object = (String)this.ids.get(n);
                    bCPGOutputStream.writePacket(new UserIDPacket((String)object));
                } else {
                    object = (PGPUserAttributeSubpacketVector)this.ids.get(n);
                    bCPGOutputStream.writePacket(new UserAttributePacket(((PGPUserAttributeSubpacketVector)object).toSubpacketArray()));
                }
                if (this.idTrusts.get(n) != null) {
                    bCPGOutputStream.writePacket((ContainedPacket)this.idTrusts.get(n));
                }
                object = (ArrayList)this.idSigs.get(n);
                int n2 = 0;
                while (n2 != ((ArrayList)object).size()) {
                    ((PGPSignature)((ArrayList)object).get(n2)).encode(bCPGOutputStream);
                    ++n2;
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n != this.subSigs.size()) {
                ((PGPSignature)this.subSigs.get(n)).encode(bCPGOutputStream);
                ++n;
            }
        }
    }
}

