/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;

public class PGPPublicKeyRingCollection {
    private HashMap pubRings = new HashMap();
    private ArrayList order = new ArrayList();

    public PGPPublicKeyRingCollection(byte[] byArray) throws IOException, PGPException {
        this(new ByteArrayInputStream(byArray));
    }

    public PGPPublicKeyRingCollection(InputStream inputStream) throws IOException, PGPException {
        PGPObjectFactory pGPObjectFactory = new PGPObjectFactory(inputStream);
        PGPPublicKeyRing pGPPublicKeyRing = null;
        while ((pGPPublicKeyRing = (PGPPublicKeyRing)pGPObjectFactory.nextObject()) != null) {
            Long l = new Long(pGPPublicKeyRing.getPublicKey().getKeyID());
            this.pubRings.put(l, pGPPublicKeyRing);
            this.order.add(l);
        }
    }

    public PGPPublicKeyRingCollection(Collection collection) throws IOException, PGPException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            PGPPublicKeyRing pGPPublicKeyRing = (PGPPublicKeyRing)iterator.next();
            Long l = new Long(pGPPublicKeyRing.getPublicKey().getKeyID());
            this.pubRings.put(l, pGPPublicKeyRing);
            this.order.add(l);
        }
    }

    public Iterator getKeyRings() {
        return this.pubRings.values().iterator();
    }

    public PGPPublicKey getPublicKey(long l) throws PGPException {
        Iterator iterator = this.getKeyRings();
        while (iterator.hasNext()) {
            PGPPublicKeyRing pGPPublicKeyRing = (PGPPublicKeyRing)iterator.next();
            PGPPublicKey pGPPublicKey = pGPPublicKeyRing.getPublicKey(l);
            if (pGPPublicKey == null) continue;
            return pGPPublicKey;
        }
        return null;
    }

    public PGPPublicKeyRing getPublicKeyRing(long l) throws PGPException {
        Long l2 = new Long(l);
        if (this.pubRings.containsKey(l2)) {
            return (PGPPublicKeyRing)this.pubRings.get(l2);
        }
        Iterator iterator = this.getKeyRings();
        while (iterator.hasNext()) {
            PGPPublicKeyRing pGPPublicKeyRing = (PGPPublicKeyRing)iterator.next();
            PGPPublicKey pGPPublicKey = pGPPublicKeyRing.getPublicKey(l);
            if (pGPPublicKey == null) continue;
            return pGPPublicKeyRing;
        }
        return null;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void encode(OutputStream outputStream) throws IOException {
        BCPGOutputStream bCPGOutputStream = outputStream instanceof BCPGOutputStream ? (BCPGOutputStream)outputStream : new BCPGOutputStream(outputStream);
        Iterator iterator = this.order.iterator();
        while (iterator.hasNext()) {
            PGPPublicKeyRing pGPPublicKeyRing = (PGPPublicKeyRing)this.pubRings.get(iterator.next());
            pGPPublicKeyRing.encode(bCPGOutputStream);
        }
    }
}

