/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.sql.Date;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.bcpg.HashAlgorithmTags;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.util.encoders.Base64;

public class PGPUtil
implements HashAlgorithmTags {
    private static String defProvider = "BC";
    private static final int READ_AHEAD = 60;

    public static InputStream getDecoderStream(InputStream inputStream) throws IOException {
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        inputStream.mark(60);
        int n = inputStream.read();
        if ((n & 0x80) != 0) {
            inputStream.reset();
            return inputStream;
        }
        if (!PGPUtil.isPossiblyBase64(n)) {
            inputStream.reset();
            return new ArmoredInputStream(inputStream);
        }
        byte[] byArray = new byte[60];
        int n2 = 0;
        int n3 = 1;
        byArray[0] = (byte)n;
        while (n2 != 60 && (n = inputStream.read()) >= 0) {
            if (!PGPUtil.isPossiblyBase64(n)) {
                inputStream.reset();
                return new ArmoredInputStream(inputStream);
            }
            if (n != 10 && n != 13) {
                byArray[n3++] = (byte)n;
            }
            ++n2;
        }
        inputStream.reset();
        if (n2 < 4) {
            return new ArmoredInputStream(inputStream);
        }
        byte[] byArray2 = new byte[8];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        byte[] byArray3 = Base64.decode((byte[])byArray2);
        if ((byArray3[0] & 0x80) != 0) {
            return new ArmoredInputStream(inputStream, false);
        }
        return new ArmoredInputStream(inputStream);
    }

    public static String getDefaultProvider() {
        return defProvider;
    }

    static String getDigestName(int n) throws PGPException {
        switch (n) {
            case 2: {
                return "SHA1";
            }
            case 5: {
                return "MD2";
            }
            case 1: {
                return "MD5";
            }
            case 3: {
                return "RIPEMD160";
            }
        }
        throw new PGPException("unknown hash algorithm tag in getDigestName: " + n);
    }

    static String getSignatureName(int n, int n2) throws PGPException {
        String string;
        switch (n) {
            case 1: 
            case 3: {
                string = "RSA";
                break;
            }
            case 17: {
                string = "DSA";
                break;
            }
            default: {
                throw new PGPException("unknown algorithm tag in signature:" + n);
            }
        }
        return String.valueOf(PGPUtil.getDigestName(n2)) + "with" + string;
    }

    static String getSymmetricCipherName(int n) throws PGPException {
        switch (n) {
            case 0: {
                return null;
            }
            case 2: {
                return "DESEDE";
            }
            case 1: {
                return "IDEA";
            }
            case 3: {
                return "CAST5";
            }
            case 4: {
                return "Blowfish";
            }
            case 5: {
                return "SAFER";
            }
            case 6: {
                return "DES";
            }
            case 7: {
                return "AES";
            }
            case 8: {
                return "AES";
            }
            case 9: {
                return "AES";
            }
            case 10: {
                return "Twofish";
            }
        }
        throw new PGPException("unknown symmetric algorithm: " + n);
    }

    private static boolean isPossiblyBase64(int n) {
        return n >= 65 && n <= 90 || n >= 97 && n <= 122 || n >= 48 && n <= 57 || n == 43 || n == 47 || n == 13 || n == 10;
    }

    public static SecretKey makeKeyFromPassPhrase(int n, S2K s2K, char[] cArray, String string) throws PGPException, NoSuchProviderException {
        String string2 = null;
        int n2 = 0;
        switch (n) {
            case 2: {
                n2 = 192;
                string2 = "DES_EDE";
                break;
            }
            case 1: {
                n2 = 128;
                string2 = "IDEA";
                break;
            }
            case 3: {
                n2 = 128;
                string2 = "CAST5";
                break;
            }
            case 4: {
                n2 = 128;
                string2 = "Blowfish";
                break;
            }
            case 5: {
                n2 = 128;
                string2 = "SAFER";
                break;
            }
            case 6: {
                n2 = 64;
                string2 = "DES";
                break;
            }
            case 7: {
                n2 = 128;
                string2 = "AES";
                break;
            }
            case 8: {
                n2 = 192;
                string2 = "AES";
                break;
            }
            case 9: {
                n2 = 256;
                string2 = "AES";
                break;
            }
            case 10: {
                n2 = 256;
                string2 = "Twofish";
                break;
            }
            default: {
                throw new PGPException("unknown symmetric algorithm: " + n);
            }
        }
        byte[] byArray = new byte[cArray.length];
        int n3 = 0;
        while (n3 != cArray.length) {
            byArray[n3] = (byte)cArray[n3];
            ++n3;
        }
        byte[] byArray2 = new byte[(n2 + 7) / 8];
        int n4 = 0;
        int n5 = 0;
        while (n4 < byArray2.length) {
            MessageDigest messageDigest;
            block35: {
                int n6;
                block36: {
                    if (s2K == null) break block36;
                    try {
                        switch (s2K.getHashAlgorithm()) {
                            case 2: {
                                messageDigest = MessageDigest.getInstance("SHA1", string);
                                break;
                            }
                            default: {
                                throw new PGPException("unknown hash algorithm: " + s2K.getHashAlgorithm());
                            }
                        }
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new PGPException("can't find S2K digest", noSuchAlgorithmException);
                    }
                    n6 = 0;
                    while (n6 != n5) {
                        messageDigest.update((byte)0);
                        ++n6;
                    }
                    byte[] byArray3 = s2K.getIV();
                    switch (s2K.getType()) {
                        case 0: {
                            messageDigest.update(byArray);
                            break block35;
                        }
                        case 1: {
                            messageDigest.update(byArray3);
                            messageDigest.update(byArray);
                            break block35;
                        }
                        case 3: {
                            long l = s2K.getIterationCount();
                            messageDigest.update(byArray3);
                            messageDigest.update(byArray);
                            l -= (long)(byArray3.length + byArray.length);
                            while (l > 0L) {
                                if (l < (long)byArray3.length) {
                                    messageDigest.update(byArray3, 0, (int)l);
                                    break block35;
                                }
                                messageDigest.update(byArray3);
                                if ((l -= (long)byArray3.length) < (long)byArray.length) {
                                    messageDigest.update(byArray, 0, (int)l);
                                    l = 0L;
                                    continue;
                                }
                                messageDigest.update(byArray);
                                l -= (long)byArray.length;
                            }
                            break block35;
                        }
                        default: {
                            throw new PGPException("unknown S2K type: " + s2K.getType());
                        }
                    }
                }
                try {
                    messageDigest = MessageDigest.getInstance("MD5", string);
                    n6 = 0;
                    while (n6 != n5) {
                        messageDigest.update((byte)0);
                        ++n6;
                    }
                    messageDigest.update(byArray);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new PGPException("can't find MD5 digest", noSuchAlgorithmException);
                }
            }
            byte[] byArray4 = messageDigest.digest();
            if (byArray4.length > byArray2.length - n4) {
                System.arraycopy(byArray4, 0, byArray2, n4, byArray2.length - n4);
            } else {
                System.arraycopy(byArray4, 0, byArray2, n4, byArray4.length);
            }
            n4 += byArray4.length;
            ++n5;
        }
        int n7 = 0;
        while (n7 != byArray.length) {
            byArray[n7] = 0;
            ++n7;
        }
        return new SecretKeySpec(byArray2, string2);
    }

    public static SecretKey makeKeyFromPassPhrase(int n, char[] cArray, String string) throws NoSuchProviderException, PGPException {
        return PGPUtil.makeKeyFromPassPhrase(n, null, cArray, string);
    }

    public static SecretKey makeRandomKey(int n, SecureRandom secureRandom) throws PGPException {
        String string = null;
        int n2 = 0;
        switch (n) {
            case 2: {
                n2 = 192;
                string = "DES_EDE";
                break;
            }
            case 1: {
                n2 = 128;
                string = "IDEA";
                break;
            }
            case 3: {
                n2 = 128;
                string = "CAST5";
                break;
            }
            case 4: {
                n2 = 128;
                string = "Blowfish";
                break;
            }
            case 5: {
                n2 = 128;
                string = "SAFER";
                break;
            }
            case 6: {
                n2 = 64;
                string = "DES";
                break;
            }
            case 7: {
                n2 = 128;
                string = "AES";
                break;
            }
            case 8: {
                n2 = 192;
                string = "AES";
                break;
            }
            case 9: {
                n2 = 256;
                string = "AES";
                break;
            }
            case 10: {
                n2 = 256;
                string = "Twofish";
                break;
            }
            default: {
                throw new PGPException("unknown symmetric algorithm: " + n);
            }
        }
        byte[] byArray = new byte[(n2 + 7) / 8];
        secureRandom.nextBytes(byArray);
        return new SecretKeySpec(byArray, string);
    }

    public static void setDefaultProvider(String string) {
        defProvider = string;
    }

    public static void writeFileToLiteralData(OutputStream outputStream, char c, File file) throws IOException {
        int n;
        PGPLiteralDataGenerator pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
        OutputStream outputStream2 = pGPLiteralDataGenerator.open(outputStream, c, file.getName(), file.length(), new Date(file.lastModified()));
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[4096];
        while ((n = fileInputStream.read(byArray)) > 0) {
            outputStream2.write(byArray, 0, n);
        }
        pGPLiteralDataGenerator.close();
    }
}

