package org.bouncycastle.openpgp;

import org.bouncycastle.bcpg.UserAttributeSubpacket;
import org.bouncycastle.bcpg.UserAttributeSubpacketTags;
import org.bouncycastle.bcpg.attr.ImageAttribute;

/**
 * Container for a list of signature subpackets.
 */
public class PGPUserAttributeSubpacketVector
{
	UserAttributeSubpacket[]	packets;
	
	PGPUserAttributeSubpacketVector(
		UserAttributeSubpacket[]	packets)
	{
		this.packets = packets;
	}
	
	public UserAttributeSubpacket getSubpacket(
		int	type)
	{
		for (int i = 0; i != packets.length; i++)
		{
			if (packets[i].getType() == type)
			{
				return packets[i];
			}
		}
		
		return null;
	}
	
	public ImageAttribute getImageAttribute()
	{
		UserAttributeSubpacket	p = this.getSubpacket(UserAttributeSubpacketTags.IMAGE_ATTRIBUTE);
		
		if (p == null)
		{
			return null;
		}
					
		return (ImageAttribute)p;
	}
	
	UserAttributeSubpacket[] toSubpacketArray()
	{
		return packets;
	}
}
