/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.examples;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;

public class ClearSignedFileProcessor {
    public static void main(String[] stringArray) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (stringArray[0].equals("-s")) {
            InputStream inputStream = PGPUtil.getDecoderStream(new FileInputStream(stringArray[2]));
            FileOutputStream fileOutputStream = new FileOutputStream(String.valueOf(stringArray[1]) + ".asc");
            ClearSignedFileProcessor.signFile(stringArray[1], inputStream, fileOutputStream, stringArray[3].toCharArray());
        } else if (stringArray[0].equals("-v")) {
            FileInputStream fileInputStream = new FileInputStream(stringArray[1]);
            InputStream inputStream = PGPUtil.getDecoderStream(new FileInputStream(stringArray[2]));
            ClearSignedFileProcessor.verifyFile(fileInputStream, inputStream);
        } else {
            System.err.println("usage: ClearSignedFileProcessor [-s file keyfile passPhrase]|[-v sigFile keyFile]");
        }
    }

    private static PGPSecretKey readSecretKey(InputStream inputStream) throws IOException, PGPException {
        PGPSecretKeyRingCollection pGPSecretKeyRingCollection = new PGPSecretKeyRingCollection(inputStream);
        PGPSecretKey pGPSecretKey = null;
        Iterator iterator = pGPSecretKeyRingCollection.getKeyRings();
        while (pGPSecretKey == null && iterator.hasNext()) {
            PGPSecretKeyRing pGPSecretKeyRing = (PGPSecretKeyRing)iterator.next();
            Iterator iterator2 = pGPSecretKeyRing.getSecretKeys();
            while (pGPSecretKey == null && iterator2.hasNext()) {
                PGPSecretKey pGPSecretKey2 = (PGPSecretKey)iterator2.next();
                if (!pGPSecretKey2.isSigningKey()) continue;
                pGPSecretKey = pGPSecretKey2;
            }
        }
        if (pGPSecretKey == null) {
            throw new IllegalArgumentException("Can't find signing key in key ring.");
        }
        return pGPSecretKey;
    }

    private static void signFile(String string, InputStream inputStream, OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, PGPException, SignatureException {
        PGPSecretKey pGPSecretKey = ClearSignedFileProcessor.readSecretKey(inputStream);
        PGPPrivateKey pGPPrivateKey = pGPSecretKey.extractPrivateKey(cArray, "BC");
        PGPSignatureGenerator pGPSignatureGenerator = new PGPSignatureGenerator(pGPSecretKey.getPublicKey().getAlgorithm(), 2, "BC");
        pGPSignatureGenerator.initSign(1, pGPPrivateKey);
        FileInputStream fileInputStream = new FileInputStream(string);
        int n = 0;
        ArmoredOutputStream armoredOutputStream = new ArmoredOutputStream(outputStream);
        armoredOutputStream.beginClearText(2);
        boolean bl = false;
        while ((n = fileInputStream.read()) >= 0) {
            armoredOutputStream.write(n);
            if (bl) {
                pGPSignatureGenerator.update((byte)10);
                bl = false;
            }
            if (n == 10) {
                bl = true;
                continue;
            }
            pGPSignatureGenerator.update((byte)n);
        }
        armoredOutputStream.endClearText();
        BCPGOutputStream bCPGOutputStream = new BCPGOutputStream(armoredOutputStream);
        pGPSignatureGenerator.generate().encode(bCPGOutputStream);
        armoredOutputStream.close();
    }

    private static void verifyFile(InputStream inputStream, InputStream inputStream2) throws Exception {
        int n;
        ArmoredInputStream armoredInputStream = new ArmoredInputStream(inputStream);
        boolean bl = false;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = armoredInputStream.read()) >= 0 && armoredInputStream.isClearText()) {
            if (bl) {
                byteArrayOutputStream.write(10);
                bl = false;
            }
            if (n == 10) {
                bl = true;
                continue;
            }
            byteArrayOutputStream.write((byte)n);
        }
        PGPPublicKeyRingCollection pGPPublicKeyRingCollection = new PGPPublicKeyRingCollection(inputStream2);
        PGPObjectFactory pGPObjectFactory = new PGPObjectFactory(armoredInputStream);
        PGPSignatureList pGPSignatureList = (PGPSignatureList)pGPObjectFactory.nextObject();
        PGPSignature pGPSignature = pGPSignatureList.get(0);
        pGPSignature.initVerify(pGPPublicKeyRingCollection.getPublicKey(pGPSignature.getKeyID()), "BC");
        pGPSignature.update(byteArrayOutputStream.toByteArray());
        if (pGPSignature.verify()) {
            System.out.println("signature verified.");
        } else {
            System.out.println("signature verification failed.");
        }
    }
}

