/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Date;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.bcpg.OnePassSignaturePacket;
import org.bouncycastle.bcpg.SignaturePacket;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.bcpg.sig.IssuerKeyID;
import org.bouncycastle.bcpg.sig.SignatureCreationTime;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUtil;

public class PGPSignatureGenerator {
    private int keyAlgorithm;
    private int hashAlgorithm;
    private PGPPrivateKey privKey;
    private Signature sig;
    private MessageDigest dig;
    private int signatureType;
    private boolean creationTimeFound;
    private boolean issuerKeyIDFound;
    SignatureSubpacket[] unhashed = new SignatureSubpacket[0];
    SignatureSubpacket[] hashed = new SignatureSubpacket[2];

    public PGPSignatureGenerator(int n, int n2, String string) throws NoSuchAlgorithmException, NoSuchProviderException, PGPException {
        this.keyAlgorithm = n;
        this.hashAlgorithm = n2;
        this.dig = MessageDigest.getInstance(PGPUtil.getDigestName(n2), string);
        this.sig = Signature.getInstance(PGPUtil.getSignatureName(n, n2), string);
    }

    public void initSign(int n, PGPPrivateKey pGPPrivateKey) throws PGPException {
        this.privKey = pGPPrivateKey;
        this.signatureType = n;
        try {
            this.sig.initSign(pGPPrivateKey.getKey());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PGPException("invalid key.", invalidKeyException);
        }
        this.dig.reset();
    }

    public void update(byte by) throws SignatureException {
        if (this.signatureType == 1) {
            if (by == 10) {
                this.sig.update((byte)13);
                this.sig.update((byte)10);
                this.dig.update((byte)13);
                this.dig.update((byte)10);
                return;
            }
            if (by == 13) {
                return;
            }
        }
        this.sig.update(by);
        this.dig.update(by);
    }

    public void update(byte[] byArray) throws SignatureException {
        if (this.signatureType == 1) {
            int n = 0;
            while (n != byArray.length) {
                this.update(byArray[n]);
                ++n;
            }
        } else {
            this.sig.update(byArray);
            this.dig.update(byArray);
        }
    }

    public void update(byte[] byArray, int n, int n2) throws SignatureException {
        if (this.signatureType == 1) {
            int n3 = n + n2;
            int n4 = n;
            while (n4 != n3) {
                this.update(byArray[n4]);
                ++n4;
            }
        } else {
            this.sig.update(byArray, n, n2);
            this.dig.update(byArray, n, n2);
        }
    }

    public void setHashedSubpackets(PGPSignatureSubpacketVector pGPSignatureSubpacketVector) {
        this.creationTimeFound = false;
        this.issuerKeyIDFound = false;
        if (pGPSignatureSubpacketVector == null) {
            this.hashed = new SignatureSubpacket[2];
            return;
        }
        SignatureSubpacket[] signatureSubpacketArray = pGPSignatureSubpacketVector.toSubpacketArray();
        int n = 0;
        while (n != this.hashed.length) {
            if (signatureSubpacketArray[n].getType() == 2) {
                this.creationTimeFound = true;
            } else if (signatureSubpacketArray[n].getType() == 16) {
                this.issuerKeyIDFound = true;
            }
            ++n;
        }
        if (this.creationTimeFound && this.issuerKeyIDFound) {
            this.hashed = signatureSubpacketArray;
        } else if (this.creationTimeFound || this.issuerKeyIDFound) {
            this.hashed = new SignatureSubpacket[signatureSubpacketArray.length + 1];
            System.arraycopy(signatureSubpacketArray, 0, this.hashed, 1, signatureSubpacketArray.length);
        } else {
            this.hashed = new SignatureSubpacket[signatureSubpacketArray.length + 2];
            System.arraycopy(signatureSubpacketArray, 0, this.hashed, 2, signatureSubpacketArray.length);
        }
    }

    public void setUnhashedSubpackets(PGPSignatureSubpacketVector pGPSignatureSubpacketVector) {
        if (pGPSignatureSubpacketVector == null) {
            this.unhashed = new SignatureSubpacket[0];
            return;
        }
        this.unhashed = pGPSignatureSubpacketVector.toSubpacketArray();
    }

    public PGPOnePassSignature generateOnePassVersion(boolean bl) throws PGPException {
        return new PGPOnePassSignature(new OnePassSignaturePacket(this.signatureType, this.hashAlgorithm, this.keyAlgorithm, this.privKey.getKeyID(), bl));
    }

    public PGPSignature generate() throws PGPException, SignatureException {
        MPInteger[] mPIntegerArray;
        Object object;
        Object object2;
        int n = 4;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        if (!this.creationTimeFound) {
            this.hashed[n2++] = new SignatureCreationTime(false, new Date());
        }
        if (!this.issuerKeyIDFound) {
            this.hashed[n2++] = new IssuerKeyID(false, this.privKey.getKeyID());
        }
        try {
            byteArrayOutputStream.write((byte)n);
            byteArrayOutputStream.write((byte)this.signatureType);
            byteArrayOutputStream.write((byte)this.keyAlgorithm);
            byteArrayOutputStream.write((byte)this.hashAlgorithm);
            object2 = new ByteArrayOutputStream();
            int n3 = 0;
            while (n3 != this.hashed.length) {
                this.hashed[n3].encode((OutputStream)object2);
                ++n3;
            }
            object = ((ByteArrayOutputStream)object2).toByteArray();
            byteArrayOutputStream.write((byte)(((byte[])object).length >> 8));
            byteArrayOutputStream.write((byte)((byte[])object).length);
            byteArrayOutputStream.write((byte[])object);
        }
        catch (IOException iOException) {
            throw new PGPException("exception encoding hashed data.", iOException);
        }
        object2 = byteArrayOutputStream.toByteArray();
        this.update((byte[])object2);
        this.update((byte)n);
        this.update((byte)-1);
        this.update((byte)(((Object)object2).length >> 24));
        this.update((byte)(((Object)object2).length >> 16));
        this.update((byte)(((Object)object2).length >> 8));
        this.update((byte)((Object)object2).length);
        if (this.keyAlgorithm == 3 || this.keyAlgorithm == 1) {
            mPIntegerArray = new MPInteger[]{new MPInteger(new BigInteger(1, this.sig.sign()))};
        } else {
            DERInteger dERInteger;
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(this.sig.sign()));
            try {
                ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
                object = (DERInteger)aSN1Sequence.getObjectAt(0);
                dERInteger = (DERInteger)aSN1Sequence.getObjectAt(1);
            }
            catch (IOException iOException) {
                throw new PGPException("exception encoding signature", iOException);
            }
            mPIntegerArray = new MPInteger[]{new MPInteger(object.getValue()), new MPInteger(dERInteger.getValue())};
        }
        byte[] byArray = this.dig.digest();
        object = new byte[]{byArray[0], byArray[1]};
        return new PGPSignature(new SignaturePacket(this.signatureType, this.privKey.getKeyID(), this.keyAlgorithm, this.hashAlgorithm, this.hashed, this.unhashed, (byte[])object, mPIntegerArray));
    }

    public PGPSignature generateCertification(String string, PGPPublicKey pGPPublicKey) throws SignatureException, PGPException {
        byte[] byArray;
        try {
            byArray = pGPPublicKey.publicPk.getEncodedContents();
        }
        catch (IOException iOException) {
            throw new PGPException("exception preparing key.", iOException);
        }
        this.update((byte)-103);
        this.update((byte)(byArray.length >> 8));
        this.update((byte)byArray.length);
        this.update(byArray);
        byte[] byArray2 = new byte[string.length()];
        int n = 0;
        while (n != byArray2.length) {
            byArray2[n] = (byte)string.charAt(n);
            ++n;
        }
        this.update((byte)-76);
        this.update((byte)(byArray2.length >> 24));
        this.update((byte)(byArray2.length >> 16));
        this.update((byte)(byArray2.length >> 8));
        this.update((byte)byArray2.length);
        this.update(byArray2);
        return this.generate();
    }

    public PGPSignature generateCertification(PGPPublicKey pGPPublicKey, PGPPublicKey pGPPublicKey2) throws SignatureException, PGPException {
        byte[] byArray;
        try {
            byArray = pGPPublicKey.publicPk.getEncodedContents();
        }
        catch (IOException iOException) {
            throw new PGPException("exception preparing key.", iOException);
        }
        this.update((byte)-103);
        this.update((byte)(byArray.length >> 8));
        this.update((byte)byArray.length);
        this.update(byArray);
        try {
            byArray = pGPPublicKey2.publicPk.getEncodedContents();
        }
        catch (IOException iOException) {
            throw new PGPException("exception preparing key.", iOException);
        }
        this.update((byte)-103);
        this.update((byte)(byArray.length >> 8));
        this.update((byte)byArray.length);
        this.update(byArray);
        return this.generate();
    }
}

