/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.KeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.bouncycastle.bcpg.BCPGKey;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.DSAPublicBCPGKey;
import org.bouncycastle.bcpg.ElGamalPublicBCPGKey;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.bcpg.PublicKeyAlgorithmTags;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.RSAPublicBCPGKey;
import org.bouncycastle.bcpg.TrustPacket;
import org.bouncycastle.bcpg.UserAttributePacket;
import org.bouncycastle.bcpg.UserIDPacket;
import org.bouncycastle.jce.interfaces.ElGamalPublicKey;
import org.bouncycastle.jce.spec.ElGamalParameterSpec;
import org.bouncycastle.jce.spec.ElGamalPublicKeySpec;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;

public class PGPPublicKey
implements PublicKeyAlgorithmTags {
    private long keyID;
    private byte[] fingerprint;
    private int keyStrength;
    PublicKeyPacket publicPk;
    TrustPacket trustPk;
    ArrayList ids = new ArrayList();
    ArrayList idTrusts = new ArrayList();
    ArrayList idSigs = new ArrayList();
    ArrayList subSigs = null;

    private void init(MessageDigest messageDigest) throws IOException {
        BCPGKey bCPGKey = this.publicPk.getKey();
        if (this.publicPk.getVersion() <= 3) {
            RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)bCPGKey;
            this.keyID = rSAPublicBCPGKey.getModulus().longValue();
            messageDigest.update(new MPInteger(rSAPublicBCPGKey.getModulus()).getEncoded());
            messageDigest.update(new MPInteger(rSAPublicBCPGKey.getPublicExponent()).getEncoded());
            this.fingerprint = messageDigest.digest();
            this.keyStrength = rSAPublicBCPGKey.getModulus().bitLength();
        } else {
            byte[] byArray = this.publicPk.getEncodedContents();
            messageDigest.update((byte)-103);
            messageDigest.update((byte)(byArray.length >> 8));
            messageDigest.update((byte)byArray.length);
            messageDigest.update(byArray);
            this.fingerprint = messageDigest.digest();
            this.keyID = (long)(this.fingerprint[this.fingerprint.length - 8] & 0xFF) << 56 | (long)(this.fingerprint[this.fingerprint.length - 7] & 0xFF) << 48 | (long)(this.fingerprint[this.fingerprint.length - 6] & 0xFF) << 40 | (long)(this.fingerprint[this.fingerprint.length - 5] & 0xFF) << 32 | (long)(this.fingerprint[this.fingerprint.length - 4] & 0xFF) << 24 | (long)(this.fingerprint[this.fingerprint.length - 3] & 0xFF) << 16 | (long)(this.fingerprint[this.fingerprint.length - 2] & 0xFF) << 8 | (long)(this.fingerprint[this.fingerprint.length - 1] & 0xFF);
            if (bCPGKey instanceof RSAPublicBCPGKey) {
                this.keyStrength = ((RSAPublicBCPGKey)bCPGKey).getModulus().bitLength();
            } else if (bCPGKey instanceof DSAPublicBCPGKey) {
                this.keyStrength = ((DSAPublicBCPGKey)bCPGKey).getG().bitLength();
            } else if (bCPGKey instanceof ElGamalPublicBCPGKey) {
                this.keyStrength = ((ElGamalPublicBCPGKey)bCPGKey).getG().bitLength();
            }
        }
    }

    public PGPPublicKey(int n, PublicKey publicKey, Date date, String string) throws PGPException, NoSuchProviderException {
        PublicKeyPacket publicKeyPacket;
        PublicKey publicKey2;
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA1", string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PGPException("can't find SHA1 digest");
        }
        if (publicKey instanceof RSAPublicKey) {
            publicKey2 = (RSAPublicKey)publicKey;
            publicKeyPacket = new PublicKeyPacket(n, date, new RSAPublicBCPGKey(publicKey2.getModulus(), publicKey2.getPublicExponent()));
        } else if (publicKey instanceof DSAPublicKey) {
            publicKey2 = (DSAPublicKey)publicKey;
            DSAParams dSAParams = publicKey2.getParams();
            publicKeyPacket = new PublicKeyPacket(n, date, new DSAPublicBCPGKey(dSAParams.getP(), dSAParams.getQ(), dSAParams.getG(), publicKey2.getY()));
        } else if (publicKey instanceof ElGamalPublicKey) {
            publicKey2 = (ElGamalPublicKey)publicKey;
            ElGamalParameterSpec elGamalParameterSpec = publicKey2.getParams();
            publicKeyPacket = new PublicKeyPacket(n, date, new ElGamalPublicBCPGKey(elGamalParameterSpec.getP(), elGamalParameterSpec.getG(), publicKey2.getY()));
        } else {
            throw new PGPException("unknown key class");
        }
        this.publicPk = publicKeyPacket;
        this.ids = new ArrayList();
        this.idSigs = new ArrayList();
        try {
            this.init(messageDigest);
        }
        catch (IOException iOException) {
            throw new PGPException("exception calculating keyID", iOException);
        }
    }

    PGPPublicKey(PublicKeyPacket publicKeyPacket, TrustPacket trustPacket, MessageDigest messageDigest, ArrayList arrayList) throws IOException {
        this.publicPk = publicKeyPacket;
        this.trustPk = trustPacket;
        this.subSigs = arrayList;
        this.init(messageDigest);
    }

    PGPPublicKey(PGPPublicKey pGPPublicKey, TrustPacket trustPacket, ArrayList arrayList) {
        this.publicPk = pGPPublicKey.publicPk;
        this.trustPk = trustPacket;
        this.subSigs = arrayList;
        this.fingerprint = pGPPublicKey.fingerprint;
        this.keyID = pGPPublicKey.keyID;
        this.keyStrength = pGPPublicKey.keyStrength;
    }

    PGPPublicKey(PGPPublicKey pGPPublicKey) {
        this.publicPk = pGPPublicKey.publicPk;
        this.ids = new ArrayList(pGPPublicKey.ids);
        this.idTrusts = new ArrayList(pGPPublicKey.idTrusts);
        this.idSigs = new ArrayList(pGPPublicKey.idSigs.size());
        int n = 0;
        while (n != pGPPublicKey.idSigs.size()) {
            this.idSigs.add(new ArrayList((ArrayList)pGPPublicKey.idSigs.get(n)));
            ++n;
        }
        if (pGPPublicKey.subSigs != null) {
            this.subSigs = new ArrayList(pGPPublicKey.subSigs.size());
            int n2 = 0;
            while (n2 != pGPPublicKey.subSigs.size()) {
                this.subSigs.add(pGPPublicKey.subSigs.get(n2));
                ++n2;
            }
        }
        this.fingerprint = pGPPublicKey.fingerprint;
        this.keyID = pGPPublicKey.keyID;
        this.keyStrength = pGPPublicKey.keyStrength;
    }

    PGPPublicKey(PublicKeyPacket publicKeyPacket, TrustPacket trustPacket, MessageDigest messageDigest, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) throws IOException {
        this.publicPk = publicKeyPacket;
        this.trustPk = trustPacket;
        this.ids = arrayList;
        this.idTrusts = arrayList2;
        this.idSigs = arrayList3;
        this.init(messageDigest);
    }

    PGPPublicKey(PublicKeyPacket publicKeyPacket, ArrayList arrayList, ArrayList arrayList2) throws IOException {
        this.publicPk = publicKeyPacket;
        this.ids = arrayList;
        this.idSigs = arrayList2;
    }

    public int getVersion() {
        return this.publicPk.getVersion();
    }

    public Date getCreationTime() {
        return this.publicPk.getTime();
    }

    public int getValidDays() {
        return this.publicPk.getValidDays();
    }

    public long getKeyID() {
        return this.keyID;
    }

    public byte[] getFingerprint() {
        byte[] byArray = new byte[this.fingerprint.length];
        System.arraycopy(this.fingerprint, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public boolean isEncryptionKey() {
        int n = this.publicPk.getAlgorithm();
        return n == 1 || n == 2 || n == 16 || n == 20;
    }

    public boolean isMasterKey() {
        return this.subSigs == null;
    }

    public int getAlgorithm() {
        return this.publicPk.getAlgorithm();
    }

    public int getBitStrength() {
        return this.keyStrength;
    }

    public PublicKey getKey(String string) throws PGPException, NoSuchProviderException {
        try {
            switch (this.publicPk.getAlgorithm()) {
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)this.publicPk.getKey();
                    RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(rSAPublicBCPGKey.getModulus(), rSAPublicBCPGKey.getPublicExponent());
                    KeyFactory keyFactory = KeyFactory.getInstance("RSA", string);
                    return keyFactory.generatePublic(rSAPublicKeySpec);
                }
                case 17: {
                    DSAPublicBCPGKey dSAPublicBCPGKey = (DSAPublicBCPGKey)this.publicPk.getKey();
                    DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(dSAPublicBCPGKey.getY(), dSAPublicBCPGKey.getP(), dSAPublicBCPGKey.getQ(), dSAPublicBCPGKey.getG());
                    KeyFactory keyFactory = KeyFactory.getInstance("DSA", string);
                    return keyFactory.generatePublic(dSAPublicKeySpec);
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elGamalPublicBCPGKey = (ElGamalPublicBCPGKey)this.publicPk.getKey();
                    ElGamalPublicKeySpec elGamalPublicKeySpec = new ElGamalPublicKeySpec(elGamalPublicBCPGKey.getY(), new ElGamalParameterSpec(elGamalPublicBCPGKey.getP(), elGamalPublicBCPGKey.getG()));
                    KeyFactory keyFactory = KeyFactory.getInstance("ElGamal", string);
                    return keyFactory.generatePublic((KeySpec)elGamalPublicKeySpec);
                }
            }
            throw new PGPException("unknown public key algorithm encountered");
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("exception constructing public key", exception);
        }
    }

    public Iterator getUserIDs() {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n != this.ids.size()) {
            if (this.ids.get(n) instanceof String) {
                arrayList.add(this.ids.get(n));
            }
            ++n;
        }
        return arrayList.iterator();
    }

    public Iterator getUserAttributes() {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n != this.ids.size()) {
            if (this.ids.get(n) instanceof PGPUserAttributeSubpacketVector) {
                arrayList.add(this.ids.get(n));
            }
            ++n;
        }
        return arrayList.iterator();
    }

    public Iterator getSignaturesForID(String string) {
        int n = 0;
        while (n != this.ids.size()) {
            if (string.equals(this.ids.get(n))) {
                return ((ArrayList)this.idSigs.get(n)).iterator();
            }
            ++n;
        }
        return null;
    }

    public Iterator getSignatures() {
        if (this.subSigs == null) {
            ArrayList arrayList = new ArrayList();
            int n = 0;
            while (n != this.ids.size()) {
                arrayList.addAll((Collection)this.ids.get(n));
                ++n;
            }
            return arrayList.iterator();
        }
        return this.subSigs.iterator();
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void encode(OutputStream outputStream) throws IOException {
        BCPGOutputStream bCPGOutputStream = outputStream instanceof BCPGOutputStream ? (BCPGOutputStream)outputStream : new BCPGOutputStream(outputStream);
        bCPGOutputStream.writePacket(this.publicPk);
        if (this.trustPk != null) {
            bCPGOutputStream.writePacket(this.trustPk);
        }
        if (this.subSigs == null) {
            int n = 0;
            while (n != this.ids.size()) {
                Object object;
                if (this.ids.get(n) instanceof String) {
                    object = (String)this.ids.get(n);
                    bCPGOutputStream.writePacket(new UserIDPacket((String)object));
                } else {
                    object = (PGPUserAttributeSubpacketVector)this.ids.get(n);
                    bCPGOutputStream.writePacket(new UserAttributePacket(((PGPUserAttributeSubpacketVector)object).toSubpacketArray()));
                }
                if (this.idTrusts.get(n) != null) {
                    bCPGOutputStream.writePacket((ContainedPacket)this.idTrusts.get(n));
                }
                object = (ArrayList)this.idSigs.get(n);
                int n2 = 0;
                while (n2 != ((ArrayList)object).size()) {
                    ((PGPSignature)((ArrayList)object).get(n2)).encode(bCPGOutputStream);
                    ++n2;
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n != this.subSigs.size()) {
                ((PGPSignature)this.subSigs.get(n)).encode(bCPGOutputStream);
                ++n;
            }
        }
    }

    public static PGPPublicKey addCertification(PGPPublicKey pGPPublicKey, String string, PGPSignature pGPSignature) {
        PGPPublicKey pGPPublicKey2 = new PGPPublicKey(pGPPublicKey);
        Iterator iterator = pGPPublicKey2.getUserIDs();
        ArrayList arrayList = null;
        int n = 0;
        while (n != pGPPublicKey2.ids.size()) {
            if (string.equals(pGPPublicKey2.ids.get(n))) {
                arrayList = (ArrayList)pGPPublicKey2.idSigs.get(n);
            }
            ++n;
        }
        if (arrayList != null) {
            arrayList.add(pGPSignature);
        } else {
            arrayList = new ArrayList();
            arrayList.add(pGPSignature);
            pGPPublicKey2.ids.add(string);
            pGPPublicKey2.idTrusts.add(null);
            pGPPublicKey2.idSigs.add(arrayList);
        }
        return pGPPublicKey2;
    }

    public static PGPPublicKey removeCertification(PGPPublicKey pGPPublicKey, String string) {
        PGPPublicKey pGPPublicKey2 = new PGPPublicKey(pGPPublicKey);
        Iterator iterator = pGPPublicKey2.getUserIDs();
        Object var4_4 = null;
        boolean bl = false;
        int n = 0;
        while (n < pGPPublicKey2.ids.size()) {
            if (string.equals(pGPPublicKey2.ids.get(n))) {
                bl = true;
                pGPPublicKey2.ids.remove(n);
                pGPPublicKey2.idTrusts.remove(n);
                pGPPublicKey2.idSigs.remove(n);
            }
            ++n;
        }
        if (!bl) {
            return null;
        }
        return pGPPublicKey2;
    }

    public static PGPPublicKey removeCertification(PGPPublicKey pGPPublicKey, String string, PGPSignature pGPSignature) {
        PGPPublicKey pGPPublicKey2 = new PGPPublicKey(pGPPublicKey);
        Iterator iterator = pGPPublicKey2.getUserIDs();
        Object var5_5 = null;
        boolean bl = false;
        int n = 0;
        while (n < pGPPublicKey2.ids.size()) {
            if (string.equals(pGPPublicKey2.ids.get(n))) {
                bl = ((ArrayList)pGPPublicKey2.idSigs.get(n)).remove(pGPSignature);
            }
            ++n;
        }
        if (!bl) {
            return null;
        }
        return pGPPublicKey2;
    }
}

