package org.bouncycastle.jce.provider;

import javax.crypto.SecretKey;

import org.bouncycastle.crypto.PBEParametersGenerator;

public class JCEPBEKey
    implements SecretKey
{
    String  algorithm;
    char[]  password;
    boolean pkcs12;

    JCEPBEKey(
        boolean pkcs12,
        String  algorithm,
        char[]  password)
    {
        this.pkcs12 = pkcs12;
        this.algorithm = algorithm;
        this.password = password;
    }

    public String getAlgorithm()
    {
        return algorithm;
    }

    public String getFormat()
    {
        return "RAW";
    }

    public byte[] getEncoded()
    {
        if (pkcs12)
        {
            return PBEParametersGenerator.PKCS12PasswordToBytes(password);
        }
        else
        {   
            return PBEParametersGenerator.PKCS5PasswordToBytes(password);
        }
    }
}
