/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.X509V3CertificateGenerator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class KeyStoreTest
implements Test {
    static char[] passwd = new char[]{'h', 'e', 'l', 'l', 'o', ' ', 'w', 'o', 'r', 'l', 'd'};

    public TestResult ecStoreTest(String string) {
        ECCurve.Fp fp = new ECCurve.Fp(new BigInteger("883423532389192164791648750360308885314476597252960362792450860609699839"), new BigInteger("7fffffffffffffffffffffff7fffffffffff8000000000007ffffffffffc", 16), new BigInteger("6b016c3bdcf18941d0d654921475ca71a9db2fb27d1d37796185c2942c0a", 16));
        ECParameterSpec eCParameterSpec = new ECParameterSpec((ECCurve)fp, fp.decodePoint(Hex.decode((String)"020ffa963cdca8816ccc33b8642bedf905c3d358573d3f27fbbd3b3cb9aaaf")), new BigInteger("883423532389192164791648750360308884807550341691627752275345424702807307"));
        try {
            Object object;
            Closeable closeable;
            Object object2;
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECDSA", "BC");
            keyPairGenerator.initialize((AlgorithmParameterSpec)eCParameterSpec, new SecureRandom());
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            PublicKey publicKey = keyPair.getPublic();
            PrivateKey privateKey = keyPair.getPrivate();
            Hashtable<DERObjectIdentifier, String> hashtable = new Hashtable<DERObjectIdentifier, String>();
            Vector<DERObjectIdentifier> vector = new Vector<DERObjectIdentifier>();
            hashtable.put(X509Name.C, "AU");
            hashtable.put(X509Name.O, "The Legion of the Bouncy Castle");
            hashtable.put(X509Name.L, "Melbourne");
            hashtable.put(X509Name.ST, "Victoria");
            hashtable.put(X509Name.E, "feedback-crypto@bouncycastle.org");
            vector.addElement(X509Name.C);
            vector.addElement(X509Name.O);
            vector.addElement(X509Name.L);
            vector.addElement(X509Name.ST);
            vector.addElement(X509Name.E);
            X509V3CertificateGenerator x509V3CertificateGenerator = new X509V3CertificateGenerator();
            x509V3CertificateGenerator.setSerialNumber(BigInteger.valueOf(1L));
            x509V3CertificateGenerator.setIssuerDN((X509Name)new X509Principal(vector, hashtable));
            x509V3CertificateGenerator.setNotBefore(new Date(System.currentTimeMillis() - 50000L));
            x509V3CertificateGenerator.setNotAfter(new Date(System.currentTimeMillis() + 50000L));
            x509V3CertificateGenerator.setSubjectDN((X509Name)new X509Principal(vector, hashtable));
            x509V3CertificateGenerator.setPublicKey(publicKey);
            x509V3CertificateGenerator.setSignatureAlgorithm("ECDSAwithSHA1");
            Certificate[] certificateArray = new Certificate[1];
            try {
                object2 = x509V3CertificateGenerator.generateX509Certificate(privateKey);
                ((X509Certificate)object2).checkValidity(new Date());
                ((Certificate)object2).verify(publicKey);
                closeable = new ByteArrayInputStream(((Certificate)object2).getEncoded());
                object = CertificateFactory.getInstance("X.509", "BC");
                object2 = (X509Certificate)((CertificateFactory)object).generateCertificate((InputStream)closeable);
                certificateArray[0] = object2;
            }
            catch (Exception exception) {
                return new SimpleTestResult(false, this.getName() + ": error generating cert - " + exception.toString());
            }
            object2 = KeyStore.getInstance(string, "BC");
            ((KeyStore)object2).load(null, null);
            ((KeyStore)object2).setKeyEntry("private", privateKey, passwd, certificateArray);
            closeable = new ByteArrayOutputStream();
            ((KeyStore)object2).store((OutputStream)closeable, passwd);
            object = new ByteArrayInputStream(((ByteArrayOutputStream)closeable).toByteArray());
            object2 = KeyStore.getInstance(string, "BC");
            ((KeyStore)object2).load((InputStream)object, passwd);
            privateKey = (PrivateKey)((KeyStore)object2).getKey("private", passwd);
            byte[] byArray = publicKey.getEncoded();
            KeyFactory keyFactory = KeyFactory.getInstance(publicKey.getAlgorithm(), "BC");
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            byArray = publicKey.getEncoded();
            keyFactory = KeyFactory.getInstance(publicKey.getAlgorithm(), "BC");
            x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            byte[] byArray2 = privateKey.getEncoded();
            keyFactory = KeyFactory.getInstance(privateKey.getAlgorithm(), "BC");
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray2);
            privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            keyFactory = KeyFactory.getInstance(privateKey.getAlgorithm(), "BC");
            pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray2);
            privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": error doing EC test - " + exception.toString());
        }
    }

    public TestResult keyStoreTest(String string) {
        try {
            Object object;
            ByteArrayInputStream byteArrayInputStream;
            Object object2;
            KeyStore keyStore = KeyStore.getInstance(string, "BC");
            keyStore.load(null, null);
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
            keyPairGenerator.initialize(1024, new SecureRandom());
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)keyPair.getPrivate();
            RSAPublicKey rSAPublicKey = (RSAPublicKey)keyPair.getPublic();
            BigInteger bigInteger = rSAPrivateKey.getModulus();
            BigInteger bigInteger2 = rSAPrivateKey.getPrivateExponent();
            Hashtable<DERObjectIdentifier, String> hashtable = new Hashtable<DERObjectIdentifier, String>();
            hashtable.put(X509Name.C, "AU");
            hashtable.put(X509Name.O, "The Legion of the Bouncy Castle");
            hashtable.put(X509Name.L, "Melbourne");
            hashtable.put(X509Name.ST, "Victoria");
            hashtable.put(X509Name.EmailAddress, "feedback-crypto@bouncycastle.org");
            X509V3CertificateGenerator x509V3CertificateGenerator = new X509V3CertificateGenerator();
            x509V3CertificateGenerator.setSerialNumber(BigInteger.valueOf(1L));
            x509V3CertificateGenerator.setIssuerDN((X509Name)new X509Principal(hashtable));
            x509V3CertificateGenerator.setNotBefore(new Date(System.currentTimeMillis() - 50000L));
            x509V3CertificateGenerator.setNotAfter(new Date(System.currentTimeMillis() + 50000L));
            x509V3CertificateGenerator.setSubjectDN((X509Name)new X509Principal(hashtable));
            x509V3CertificateGenerator.setPublicKey((PublicKey)rSAPublicKey);
            x509V3CertificateGenerator.setSignatureAlgorithm("MD5WithRSAEncryption");
            Certificate[] certificateArray = new Certificate[1];
            try {
                object2 = x509V3CertificateGenerator.generateX509Certificate((PrivateKey)rSAPrivateKey);
                ((X509Certificate)object2).checkValidity(new Date());
                ((Certificate)object2).verify(rSAPublicKey);
                byteArrayInputStream = new ByteArrayInputStream(((Certificate)object2).getEncoded());
                object = CertificateFactory.getInstance("X.509", "BC");
                object2 = (X509Certificate)((CertificateFactory)object).generateCertificate(byteArrayInputStream);
                certificateArray[0] = object2;
            }
            catch (Exception exception) {
                return new SimpleTestResult(false, this.getName() + ": error generating cert - " + exception.toString());
            }
            keyStore.setKeyEntry("private", rSAPrivateKey, passwd, certificateArray);
            object2 = new ByteArrayOutputStream();
            keyStore.store((OutputStream)object2, passwd);
            byteArrayInputStream = new ByteArrayInputStream(((ByteArrayOutputStream)object2).toByteArray());
            keyStore = KeyStore.getInstance(string, "BC");
            keyStore.load(byteArrayInputStream, passwd);
            rSAPrivateKey = (RSAPrivateKey)keyStore.getKey("private", passwd);
            if (!rSAPrivateKey.getModulus().equals(bigInteger)) {
                return new SimpleTestResult(false, this.getName() + ": private key modulus wrong");
            }
            if (!rSAPrivateKey.getPrivateExponent().equals(bigInteger2)) {
                return new SimpleTestResult(false, this.getName() + ": private key exponent wrong");
            }
            object = keyStore.getCertificateChain("private")[0];
            ((Certificate)object).verify(rSAPublicKey);
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": exception - " + exception.toString());
        }
    }

    public String getName() {
        return "KeyStore";
    }

    public TestResult perform() {
        TestResult testResult = this.keyStoreTest("BKS");
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.keyStoreTest("UBER");
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.ecStoreTest("BKS");
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyStoreTest keyStoreTest = new KeyStoreTest();
        TestResult testResult = keyStoreTest.perform();
        System.out.println(testResult.toString());
    }
}

