/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.AlgorithmParameterSpec;

public class RC2ParameterSpec
implements AlgorithmParameterSpec {
    private int effectiveKeyBits;
    private byte[] iv = new byte[8];

    public RC2ParameterSpec(int n) {
        this.effectiveKeyBits = n;
    }

    public RC2ParameterSpec(int n, byte[] byArray) {
        this(n, byArray, 0);
    }

    public RC2ParameterSpec(int n, byte[] byArray, int n2) {
        this.effectiveKeyBits = n;
        this.iv = new byte[8];
        System.arraycopy(byArray, n2, this.iv, 0, this.iv.length);
    }

    public int getEffectiveKeyBits() {
        return this.effectiveKeyBits;
    }

    public byte[] getIV() {
        if (this.iv == null) {
            return null;
        }
        byte[] byArray = new byte[this.iv.length];
        System.arraycopy(this.iv, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof RC2ParameterSpec)) {
            return false;
        }
        RC2ParameterSpec rC2ParameterSpec = (RC2ParameterSpec)object;
        if (this.effectiveKeyBits != rC2ParameterSpec.effectiveKeyBits) {
            return false;
        }
        if (this.iv != null) {
            if (rC2ParameterSpec.iv == null) {
                return false;
            }
            int n = 0;
            while (n != this.iv.length) {
                if (this.iv[n] != rC2ParameterSpec.iv[n]) {
                    return false;
                }
                ++n;
            }
        } else if (rC2ParameterSpec.iv != null) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        throw new RuntimeException("Not yet implemented");
    }
}

