/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;

public class CertificatePolicies
implements DEREncodable {
    static final DERObjectIdentifier anyPolicy = new DERObjectIdentifier("2.5.29.32.0");
    Vector policies = new Vector();

    public static CertificatePolicies getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return CertificatePolicies.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static CertificatePolicies getInstance(Object object) {
        if (object instanceof CertificatePolicies) {
            return (CertificatePolicies)object;
        }
        if (object instanceof ASN1Sequence) {
            return new CertificatePolicies((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public CertificatePolicies(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)enumeration.nextElement();
            this.policies.addElement(aSN1Sequence2.getObjectAt(0));
        }
    }

    public CertificatePolicies(DERObjectIdentifier dERObjectIdentifier) {
        this.policies.addElement(dERObjectIdentifier);
    }

    public CertificatePolicies(String string) {
        this(new DERObjectIdentifier(string));
    }

    public void addPolicy(String string) {
        this.policies.addElement(new DERObjectIdentifier(string));
    }

    public String getPolicy(int n) {
        if (this.policies.size() > n) {
            return ((DERObjectIdentifier)this.policies.elementAt(n)).getId();
        }
        return null;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        int n = 0;
        while (n < this.policies.size()) {
            aSN1EncodableVector.add(new DERSequence((DERObjectIdentifier)this.policies.elementAt(n)));
            ++n;
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public String toString() {
        String string = null;
        int n = 0;
        while (n < this.policies.size()) {
            if (string != null) {
                string = string + ", ";
            }
            string = string + ((DERObjectIdentifier)this.policies.elementAt(n)).getId();
            ++n;
        }
        return "CertificatePolicies: " + string;
    }
}

