/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Null;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInformation;

public class KeyTransRecipientInformation
extends RecipientInformation {
    private KeyTransRecipientInfo info;
    private EncryptedContentInfo data;
    private static ASN1Null asn1Null = new DERNull();

    public KeyTransRecipientInformation(KeyTransRecipientInfo keyTransRecipientInfo, EncryptedContentInfo encryptedContentInfo) {
        this.info = keyTransRecipientInfo;
        this.rid = new RecipientId();
        this.data = encryptedContentInfo;
        RecipientIdentifier recipientIdentifier = keyTransRecipientInfo.getRecipientIdentifier();
        try {
            if (recipientIdentifier.isTagged()) {
                ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance((Object)recipientIdentifier.getId());
                this.rid.setSubjectKeyIdentifier(aSN1OctetString.getOctets());
            } else {
                IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance((Object)recipientIdentifier.getId());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ASN1OutputStream aSN1OutputStream = new ASN1OutputStream((OutputStream)byteArrayOutputStream);
                aSN1OutputStream.writeObject((Object)issuerAndSerialNumber.getName());
                this.rid.setIssuer(byteArrayOutputStream.toByteArray());
                this.rid.setSerialNumber(issuerAndSerialNumber.getSerialNumber().getValue());
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("invalid rid in KeyTransRecipientInformation");
        }
    }

    public byte[] getContent(Key key, String string) throws CMSException, NoSuchProviderException {
        try {
            byte[] byArray = this.info.getEncryptedKey().getOctets();
            AlgorithmIdentifier algorithmIdentifier = AlgorithmIdentifier.getInstance((Object)this.info.getKeyEncryptionAlgorithm());
            Cipher cipher = Cipher.getInstance(algorithmIdentifier.getObjectId().getId(), string);
            cipher.init(2, key);
            byte[] byArray2 = cipher.doFinal(byArray);
            byte[] byArray3 = this.data.getEncryptedContent().getOctets();
            AlgorithmIdentifier algorithmIdentifier2 = this.data.getContentEncryptionAlgorithm();
            String string2 = algorithmIdentifier2.getObjectId().getId();
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, string2);
            Cipher cipher2 = Cipher.getInstance(string2, string);
            DEREncodable dEREncodable = algorithmIdentifier2.getParameters();
            if (dEREncodable != null && !asn1Null.equals((Object)dEREncodable)) {
                AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(string2, string);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ASN1OutputStream aSN1OutputStream = new ASN1OutputStream((OutputStream)byteArrayOutputStream);
                aSN1OutputStream.writeObject((Object)algorithmIdentifier2.getParameters());
                algorithmParameters.init(byteArrayOutputStream.toByteArray(), "ASN.1");
                cipher2.init(2, (Key)secretKeySpec, algorithmParameters);
            } else if (string2.equals("1.2.840.113549.3.7") || string2.equals("1.3.6.1.4.1.188.7.1.1.2") || string2.equals("1.2.840.113533.7.66.10")) {
                cipher2.init(2, (Key)secretKeySpec, new IvParameterSpec(new byte[8]));
            } else {
                cipher2.init(2, secretKeySpec);
            }
            return cipher2.doFinal(byArray3);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find algorithm.", noSuchAlgorithmException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new CMSException("illegal blocksize in message.", illegalBlockSizeException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CMSException("required padding not supported.", noSuchPaddingException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new CMSException("bad padding in message.", badPaddingException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new CMSException("algorithm parameters invalid.", invalidAlgorithmParameterException);
        }
        catch (IOException iOException) {
            throw new CMSException("error decoding algorithm parameters.", iOException);
        }
    }
}

