/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.RC2ParameterSpec;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.EnvelopedData;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.KEKIdentifier;
import org.bouncycastle.asn1.cms.KEKRecipientInfo;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientIdentifier;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;

public class CMSEnvelopedDataGenerator {
    ArrayList recipientInfs = new ArrayList();
    public static final String DES_EDE3_CBC = "1.2.840.113549.3.7";
    public static final String RC2_CBC = "1.2.840.113549.3.2";
    public static final String IDEA_CBC = "1.3.6.1.4.1.188.7.1.1.2";
    public static final String CAST5_CBC = "1.2.840.113533.7.66.10";
    public static final String AES128_CBC = "2.16.840.1.101.3.4.1.2";
    public static final String AES192_CBC = "2.16.840.1.101.3.4.1.22";
    public static final String AES256_CBC = "2.16.840.1.101.3.4.1.42";
    SecureRandom rand = new SecureRandom();

    public void addKeyTransRecipient(X509Certificate x509Certificate) throws IllegalArgumentException {
        this.recipientInfs.add(new RecipientInf(x509Certificate));
    }

    public void addKeyTransRecipient(PublicKey publicKey, byte[] byArray) throws IllegalArgumentException {
        this.recipientInfs.add(new RecipientInf(publicKey, (ASN1OctetString)new DEROctetString(byArray)));
    }

    public void addKEKRecipient(SecretKey secretKey, byte[] byArray) {
        this.recipientInfs.add(new RecipientInf(secretKey, new KEKIdentifier(byArray, null, null)));
    }

    private DERObject makeObj(byte[] byArray) throws IOException {
        if (byArray == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
        return aSN1InputStream.readObject();
    }

    private AlgorithmIdentifier makeAlgId(String string, byte[] byArray) throws IOException {
        if (byArray != null) {
            return new AlgorithmIdentifier(new DERObjectIdentifier(string), (DEREncodable)this.makeObj(byArray));
        }
        return new AlgorithmIdentifier(new DERObjectIdentifier(string), (DEREncodable)new DERNull());
    }

    public CMSEnvelopedData generate(CMSProcessable cMSProcessable, String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        BERConstructedOctetString bERConstructedOctetString;
        SecretKey secretKey;
        AlgorithmIdentifier algorithmIdentifier;
        AlgorithmParameters algorithmParameters;
        Object object;
        Object object2;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        try {
            DERNull dERNull;
            Closeable closeable;
            Object object3;
            object2 = KeyGenerator.getInstance(string, string2);
            object = Cipher.getInstance(string, string2);
            try {
                object3 = AlgorithmParameterGenerator.getInstance(string, string2);
                algorithmParameters = ((AlgorithmParameterGenerator)object3).generateParameters();
                closeable = new ByteArrayInputStream(algorithmParameters.getEncoded("ASN.1"));
                ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)closeable);
                dERNull = aSN1InputStream.readObject();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                algorithmParameters = null;
                dERNull = new DERNull();
            }
            algorithmIdentifier = new AlgorithmIdentifier(new DERObjectIdentifier(string), (DEREncodable)dERNull);
            secretKey = ((KeyGenerator)object2).generateKey();
            ((Cipher)object).init(1, (Key)secretKey, algorithmParameters);
            object3 = new ByteArrayOutputStream();
            closeable = new CipherOutputStream((OutputStream)object3, (Cipher)object);
            cMSProcessable.write((OutputStream)closeable);
            ((CipherOutputStream)closeable).close();
            bERConstructedOctetString = new BERConstructedOctetString(((ByteArrayOutputStream)object3).toByteArray());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find algorithm.", noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CMSException("required padding not supported.", noSuchPaddingException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new CMSException("algorithm parameters invalid.", invalidAlgorithmParameterException);
        }
        catch (IOException iOException) {
            throw new CMSException("exception decoding algorithm parameters.", iOException);
        }
        object2 = this.recipientInfs.iterator();
        while (object2.hasNext()) {
            object = (RecipientInf)object2.next();
            try {
                aSN1EncodableVector.add((DEREncodable)((RecipientInf)object).toRecipientInfo(secretKey, string2));
            }
            catch (IOException iOException) {
                throw new CMSException("encoding error.", iOException);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new CMSException("key inappropriate for algorithm.", invalidKeyException);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new CMSException("error making encrypted content.", generalSecurityException);
            }
        }
        object = new EncryptedContentInfo(PKCSObjectIdentifiers.data, algorithmIdentifier, (ASN1OctetString)bERConstructedOctetString);
        algorithmParameters = new ContentInfo(PKCSObjectIdentifiers.envelopedData, (DEREncodable)new EnvelopedData(null, (ASN1Set)new DERSet((DEREncodableVector)aSN1EncodableVector), (EncryptedContentInfo)object, null));
        return new CMSEnvelopedData((ContentInfo)algorithmParameters);
    }

    public CMSEnvelopedData generate(CMSProcessable cMSProcessable, String string, int n, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        BERConstructedOctetString bERConstructedOctetString;
        SecretKey secretKey;
        AlgorithmIdentifier algorithmIdentifier;
        AlgorithmParameterGenerator algorithmParameterGenerator;
        Object object;
        Object object2;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        try {
            Object object3;
            object2 = KeyGenerator.getInstance(string, string2);
            object = Cipher.getInstance(string, string2);
            algorithmParameterGenerator = AlgorithmParameterGenerator.getInstance(string, string2);
            ((KeyGenerator)object2).init(n);
            if (string.equals(RC2_CBC)) {
                object3 = new byte[8];
                this.rand.setSeed(System.currentTimeMillis());
                this.rand.nextBytes((byte[])object3);
                algorithmParameterGenerator.init(new RC2ParameterSpec(n, (byte[])object3));
            }
            object3 = algorithmParameterGenerator.generateParameters();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((AlgorithmParameters)object3).getEncoded("ASN.1"));
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
            DERObject dERObject = aSN1InputStream.readObject();
            algorithmIdentifier = new AlgorithmIdentifier(new DERObjectIdentifier(string), (DEREncodable)dERObject);
            secretKey = ((KeyGenerator)object2).generateKey();
            ((Cipher)object).init(1, (Key)secretKey, (AlgorithmParameters)object3);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            CipherOutputStream cipherOutputStream = new CipherOutputStream(byteArrayOutputStream, (Cipher)object);
            cMSProcessable.write(cipherOutputStream);
            cipherOutputStream.close();
            bERConstructedOctetString = new BERConstructedOctetString(byteArrayOutputStream.toByteArray());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find algorithm.", noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CMSException("required padding not supported.", noSuchPaddingException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new CMSException("algorithm parameters invalid.", invalidAlgorithmParameterException);
        }
        catch (IOException iOException) {
            throw new CMSException("exception decoding algorithm parameters.", iOException);
        }
        object2 = this.recipientInfs.iterator();
        while (object2.hasNext()) {
            object = (RecipientInf)object2.next();
            try {
                aSN1EncodableVector.add((DEREncodable)((RecipientInf)object).toRecipientInfo(secretKey, string2));
            }
            catch (IOException iOException) {
                throw new CMSException("encoding error.", iOException);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new CMSException("key inappropriate for algorithm.", invalidKeyException);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new CMSException("error making encrypted content.", generalSecurityException);
            }
        }
        object = new EncryptedContentInfo(PKCSObjectIdentifiers.data, algorithmIdentifier, (ASN1OctetString)bERConstructedOctetString);
        algorithmParameterGenerator = new ContentInfo(PKCSObjectIdentifiers.envelopedData, (DEREncodable)new EnvelopedData(null, (ASN1Set)new DERSet((DEREncodableVector)aSN1EncodableVector), (EncryptedContentInfo)object, null));
        return new CMSEnvelopedData((ContentInfo)algorithmParameterGenerator);
    }

    private class RecipientInf {
        X509Certificate cert;
        AlgorithmIdentifier keyEncAlg;
        PublicKey pubKey;
        ASN1OctetString subKeyId;
        SecretKey secKey;
        KEKIdentifier secKeyId;

        RecipientInf(X509Certificate x509Certificate) {
            this.cert = x509Certificate;
            this.pubKey = x509Certificate.getPublicKey();
            try {
                byte[] byArray = x509Certificate.getTBSCertificate();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
                TBSCertificateStructure tBSCertificateStructure = TBSCertificateStructure.getInstance((Object)aSN1InputStream.readObject());
                SubjectPublicKeyInfo subjectPublicKeyInfo = tBSCertificateStructure.getSubjectPublicKeyInfo();
                this.keyEncAlg = subjectPublicKeyInfo.getAlgorithmId();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("can't extract key algorithm from this cert");
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IllegalArgumentException("can't extract tbs structure from this cert");
            }
        }

        RecipientInf(PublicKey publicKey, ASN1OctetString aSN1OctetString) {
            this.pubKey = publicKey;
            this.subKeyId = aSN1OctetString;
            try {
                byte[] byArray = publicKey.getEncoded();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
                SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)aSN1InputStream.readObject());
                this.keyEncAlg = subjectPublicKeyInfo.getAlgorithmId();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("can't extract key algorithm from this key");
            }
        }

        RecipientInf(SecretKey secretKey, KEKIdentifier kEKIdentifier) {
            this.secKey = secretKey;
            this.secKeyId = kEKIdentifier;
            if (secretKey.getAlgorithm().startsWith("DES")) {
                this.keyEncAlg = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.113549.1.9.16.3.6"), (DEREncodable)new DERNull());
            } else if (secretKey.getAlgorithm().startsWith("RC2")) {
                this.keyEncAlg = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.113549.1.9.16.3.7"), (DEREncodable)new DERInteger(58));
            } else {
                throw new IllegalArgumentException("unknown algorithm");
            }
        }

        RecipientInfo toRecipientInfo(SecretKey secretKey, String string) throws IOException, GeneralSecurityException {
            Cipher cipher = Cipher.getInstance(this.keyEncAlg.getObjectId().getId(), string);
            if (this.pubKey != null) {
                byte[] byArray = secretKey.getEncoded();
                cipher.init(1, this.pubKey);
                DEROctetString dEROctetString = new DEROctetString(cipher.doFinal(byArray));
                if (this.cert != null) {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.cert.getTBSCertificate());
                    ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
                    TBSCertificateStructure tBSCertificateStructure = TBSCertificateStructure.getInstance((Object)aSN1InputStream.readObject());
                    IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(tBSCertificateStructure.getIssuer(), tBSCertificateStructure.getSerialNumber().getValue());
                    return new RecipientInfo(new KeyTransRecipientInfo(new RecipientIdentifier(issuerAndSerialNumber), this.keyEncAlg, (ASN1OctetString)dEROctetString));
                }
                return new RecipientInfo(new KeyTransRecipientInfo(new RecipientIdentifier(this.subKeyId), this.keyEncAlg, (ASN1OctetString)dEROctetString));
            }
            cipher.init(3, this.secKey);
            DEROctetString dEROctetString = new DEROctetString(cipher.wrap(secretKey));
            return new RecipientInfo(new KEKRecipientInfo(this.secKeyId, this.keyEncAlg, (ASN1OctetString)dEROctetString));
        }
    }
}

