/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.encodings;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;

public class PKCS1Encoding
implements AsymmetricBlockCipher {
    private static int HEADER_LENGTH = 10;
    private SecureRandom random;
    private AsymmetricBlockCipher engine;
    private boolean forEncryption;
    private boolean forPrivateKey;

    public PKCS1Encoding(AsymmetricBlockCipher asymmetricBlockCipher) {
        this.engine = asymmetricBlockCipher;
    }

    private byte[] decodeBlock(byte[] byArray, int n, int n2) throws InvalidCipherTextException {
        byte[] byArray2 = this.engine.processBlock(byArray, n, n2);
        if (byArray2.length < this.getOutputBlockSize()) {
            throw new InvalidCipherTextException("block truncated");
        }
        if (byArray2[0] != 1 && byArray2[0] != 2) {
            throw new InvalidCipherTextException("unknown block type");
        }
        int n3 = 1;
        while (n3 != byArray2.length) {
            if (byArray2[n3] == 0) break;
            ++n3;
        }
        if (++n3 >= byArray2.length || n3 < HEADER_LENGTH) {
            throw new InvalidCipherTextException("no data in block");
        }
        byte[] byArray3 = new byte[byArray2.length - n3];
        System.arraycopy(byArray2, n3, byArray3, 0, byArray3.length);
        return byArray3;
    }

    /*
     * Unable to fully structure code
     */
    private byte[] encodeBlock(byte[] var1_1, int var2_2, int var3_3) throws InvalidCipherTextException {
        block4: {
            block3: {
                var4_4 = new byte[this.engine.getInputBlockSize()];
                if (!this.forPrivateKey) break block3;
                var4_4[0] = 1;
                var5_5 = 1;
                while (var5_5 != var4_4.length - var3_3 - 1) {
                    var4_4[var5_5] = -1;
                    ++var5_5;
                }
                break block4;
            }
            this.random.nextBytes(var4_4);
            var4_4[0] = 2;
            var5_6 = 1;
            ** GOTO lbl19
            {
                var4_4[var5_6] = (byte)this.random.nextInt();
                do {
                    if (var4_4[var5_6] == 0) continue block1;
                    ++var5_6;
lbl19:
                    // 2 sources

                } while (var5_6 != var4_4.length - var3_3 - 1);
            }
        }
        var4_4[var4_4.length - var3_3 - 1] = 0;
        System.arraycopy(var1_1, var2_2, var4_4, var4_4.length - var3_3, var3_3);
        return this.engine.processBlock(var4_4, 0, var4_4.length);
    }

    public int getInputBlockSize() {
        int n = this.engine.getInputBlockSize();
        if (this.forEncryption) {
            return n - HEADER_LENGTH;
        }
        return n;
    }

    public int getOutputBlockSize() {
        int n = this.engine.getOutputBlockSize();
        if (this.forEncryption) {
            return n;
        }
        return n - HEADER_LENGTH;
    }

    public AsymmetricBlockCipher getUnderlyingCipher() {
        return this.engine;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        AsymmetricKeyParameter asymmetricKeyParameter;
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            this.random = parametersWithRandom.getRandom();
            asymmetricKeyParameter = (AsymmetricKeyParameter)parametersWithRandom.getParameters();
        } else {
            this.random = new SecureRandom();
            asymmetricKeyParameter = (AsymmetricKeyParameter)cipherParameters;
        }
        this.engine.init(bl, asymmetricKeyParameter);
        this.forPrivateKey = asymmetricKeyParameter.isPrivate();
        this.forEncryption = bl;
    }

    public byte[] processBlock(byte[] byArray, int n, int n2) throws InvalidCipherTextException {
        if (this.forEncryption) {
            return this.encodeBlock(byArray, n, n2);
        }
        return this.decodeBlock(byArray, n, n2);
    }
}

