/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.ISO10126d2Padding;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.paddings.X923Padding;
import org.bouncycastle.crypto.paddings.ZeroBytePadding;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class PaddingTest
implements Test {
    private boolean isEqualTo(byte[] byArray, byte[] byArray2) {
        for (int i = 0; i != byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public TestResult testPadding(BlockCipherPadding blockCipherPadding, SecureRandom secureRandom) {
        PaddedBufferedBlockCipher paddedBufferedBlockCipher = new PaddedBufferedBlockCipher((BlockCipher)new DESEngine(), blockCipherPadding);
        KeyParameter keyParameter = new KeyParameter(Hex.decode((String)"0011223344556677"));
        try {
            for (int i = 1; i != 20; ++i) {
                byte[] byArray = new byte[i];
                byte[] byArray2 = new byte[byArray.length + 8];
                byte[] byArray3 = new byte[i];
                secureRandom.nextBytes(byArray);
                paddedBufferedBlockCipher.init(true, (CipherParameters)keyParameter);
                int n = paddedBufferedBlockCipher.processBytes(byArray, 0, byArray.length, byArray2, 0);
                n += paddedBufferedBlockCipher.doFinal(byArray2, n);
                paddedBufferedBlockCipher.init(false, (CipherParameters)keyParameter);
                int n2 = paddedBufferedBlockCipher.processBytes(byArray2, 0, n, byArray3, 0);
                n2 += paddedBufferedBlockCipher.doFinal(byArray3, n2);
                if (this.isEqualTo(byArray, byArray3)) continue;
                return new SimpleTestResult(false, this.getName() + ": falied to decrypt - i = " + i + ", padding = " + blockCipherPadding.getPaddingName());
            }
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": Exception - " + exception.toString(), exception);
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public TestResult perform() {
        SecureRandom secureRandom = new SecureRandom(new byte[20]);
        secureRandom.setSeed(System.currentTimeMillis());
        TestResult testResult = this.testPadding((BlockCipherPadding)new PKCS7Padding(), secureRandom);
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.testPadding((BlockCipherPadding)new ISO10126d2Padding(), secureRandom);
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.testPadding((BlockCipherPadding)new X923Padding(), secureRandom);
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.testPadding((BlockCipherPadding)new ZeroBytePadding(), secureRandom);
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public String getName() {
        return "PaddingTest";
    }

    public static void main(String[] stringArray) {
        PaddingTest paddingTest = new PaddingTest();
        TestResult testResult = paddingTest.perform();
        System.out.println(testResult);
    }
}

