/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.DisplayText;

public class NoticeReference
extends ASN1Encodable {
    DisplayText organization;
    ASN1Sequence noticeNumbers;

    public NoticeReference(int n, String string, ASN1Sequence aSN1Sequence) {
        this.organization = new DisplayText(n, string);
        this.noticeNumbers = aSN1Sequence;
    }

    public NoticeReference(String string, Vector vector) {
        this.organization = new DisplayText(string);
        Object e = vector.elementAt(0);
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (e instanceof Integer) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Integer n = (Integer)enumeration.nextElement();
                DERInteger dERInteger = new DERInteger(n);
                aSN1EncodableVector.add(dERInteger);
            }
        }
        this.noticeNumbers = new DERSequence(aSN1EncodableVector);
    }

    public NoticeReference(String string, ASN1Sequence aSN1Sequence) {
        this.organization = new DisplayText(string);
        this.noticeNumbers = aSN1Sequence;
    }

    public NoticeReference(ASN1Sequence aSN1Sequence) {
        this.organization = DisplayText.getInstance(aSN1Sequence.getObjectAt(0));
        this.noticeNumbers = (ASN1Sequence)aSN1Sequence.getObjectAt(1);
    }

    public static NoticeReference getInstance(Object object) {
        if (object instanceof NoticeReference) {
            return (NoticeReference)object;
        }
        if (object instanceof ASN1Sequence) {
            return new NoticeReference((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in getInstance.");
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.organization);
        aSN1EncodableVector.add(this.noticeNumbers);
        return new DERSequence(aSN1EncodableVector);
    }
}

