/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.digests.MD4Digest;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class MD4DigestTest
implements Test {
    private static String testVec1 = "";
    private static String resVec1 = "31d6cfe0d16ae931b73c59d7e0c089c0";
    private static String testVec2 = "61";
    private static String resVec2 = "bde52cb31de33e46245e05fbdbd6fb24";
    private static String testVec3 = "616263";
    private static String resVec3 = "a448017aaf21d8525fc10ae87aa6729d";
    private static String testVec4 = "3132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930313233343536373839303132333435363738393031323334353637383930";
    private static String resVec4 = "e33b4ddc9c38f2199c3e7b164fcc0536";

    public String getName() {
        return "MD4";
    }

    public static void main(String[] stringArray) {
        MD4DigestTest mD4DigestTest = new MD4DigestTest();
        TestResult testResult = mD4DigestTest.perform();
        System.out.println(testResult);
    }

    public TestResult perform() {
        MD4Digest mD4Digest = new MD4Digest();
        byte[] byArray = new byte[mD4Digest.getDigestSize()];
        mD4Digest.doFinal(byArray, 0);
        String string = new String(Hex.encode((byte[])byArray));
        if (!resVec1.equals(string)) {
            return new SimpleTestResult(false, "MD4 failing standard vector test 1" + System.getProperty("line.separator") + "    expected: " + resVec1 + System.getProperty("line.separator") + "    got     : " + string);
        }
        byte[] byArray2 = Hex.decode((String)testVec2);
        mD4Digest.update(byArray2, 0, byArray2.length);
        mD4Digest.doFinal(byArray, 0);
        string = new String(Hex.encode((byte[])byArray));
        if (!resVec2.equals(string)) {
            return new SimpleTestResult(false, "MD4 failing standard vector test 2" + System.getProperty("line.separator") + "    expected: " + resVec2 + System.getProperty("line.separator") + "    got     : " + string);
        }
        byArray2 = Hex.decode((String)testVec3);
        mD4Digest.update(byArray2, 0, byArray2.length);
        mD4Digest.doFinal(byArray, 0);
        string = new String(Hex.encode((byte[])byArray));
        if (!resVec3.equals(string)) {
            return new SimpleTestResult(false, "MD4 failing standard vector test 3" + System.getProperty("line.separator") + "    expected: " + resVec3 + System.getProperty("line.separator") + "    got     : " + string);
        }
        byArray2 = Hex.decode((String)testVec4);
        mD4Digest.update(byArray2, 0, byArray2.length);
        mD4Digest.doFinal(byArray, 0);
        string = new String(Hex.encode((byte[])byArray));
        if (!resVec4.equals(string)) {
            return new SimpleTestResult(false, "MD4 failing standard vector test 4" + System.getProperty("line.separator") + "    expected: " + resVec4 + System.getProperty("line.separator") + "    got     : " + string);
        }
        byArray2 = Hex.decode((String)testVec4);
        mD4Digest.update(byArray2, 0, byArray2.length / 2);
        MD4Digest mD4Digest2 = new MD4Digest(mD4Digest);
        mD4Digest.update(byArray2, byArray2.length / 2, byArray2.length - byArray2.length / 2);
        mD4Digest.doFinal(byArray, 0);
        string = new String(Hex.encode((byte[])byArray));
        if (!resVec4.equals(string)) {
            return new SimpleTestResult(false, "MD4 failing standard vector test 5" + System.getProperty("line.separator") + "    expected: " + resVec4 + System.getProperty("line.separator") + "    got     : " + string);
        }
        mD4Digest2.update(byArray2, byArray2.length / 2, byArray2.length - byArray2.length / 2);
        mD4Digest2.doFinal(byArray, 0);
        string = new String(Hex.encode((byte[])byArray));
        if (!resVec4.equals(string)) {
            return new SimpleTestResult(false, "MD4 failing standard vector test 5" + System.getProperty("line.separator") + "    expected: " + resVec4 + System.getProperty("line.separator") + "    got     : " + string);
        }
        return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
    }
}

