/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.ISO10126d2Padding;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.paddings.X923Padding;
import org.bouncycastle.crypto.paddings.ZeroBytePadding;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class PaddingTest
implements Test {
    public String getName() {
        return "PaddingTest";
    }

    private boolean isEqualTo(byte[] byArray, byte[] byArray2) {
        int n = 0;
        while (n != byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        PaddingTest paddingTest = new PaddingTest();
        TestResult testResult = paddingTest.perform();
        System.out.println(testResult);
    }

    public TestResult perform() {
        SecureRandom secureRandom = new SecureRandom(new byte[20]);
        secureRandom.setSeed(System.currentTimeMillis());
        TestResult testResult = this.testPadding((BlockCipherPadding)new PKCS7Padding(), secureRandom);
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.testPadding((BlockCipherPadding)new ISO10126d2Padding(), secureRandom);
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.testPadding((BlockCipherPadding)new X923Padding(), secureRandom);
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.testPadding((BlockCipherPadding)new ZeroBytePadding(), secureRandom);
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
    }

    public TestResult testPadding(BlockCipherPadding blockCipherPadding, SecureRandom secureRandom) {
        PaddedBufferedBlockCipher paddedBufferedBlockCipher = new PaddedBufferedBlockCipher((BlockCipher)new DESEngine(), blockCipherPadding);
        KeyParameter keyParameter = new KeyParameter(Hex.decode((String)"0011223344556677"));
        try {
            int n = 1;
            while (n != 20) {
                byte[] byArray = new byte[n];
                byte[] byArray2 = new byte[byArray.length + 8];
                byte[] byArray3 = new byte[n];
                secureRandom.nextBytes(byArray);
                paddedBufferedBlockCipher.init(true, (CipherParameters)keyParameter);
                int n2 = paddedBufferedBlockCipher.processBytes(byArray, 0, byArray.length, byArray2, 0);
                n2 += paddedBufferedBlockCipher.doFinal(byArray2, n2);
                paddedBufferedBlockCipher.init(false, (CipherParameters)keyParameter);
                int n3 = paddedBufferedBlockCipher.processBytes(byArray2, 0, n2, byArray3, 0);
                n3 += paddedBufferedBlockCipher.doFinal(byArray3, n3);
                if (!this.isEqualTo(byArray, byArray3)) {
                    return new SimpleTestResult(false, String.valueOf(this.getName()) + ": falied to decrypt - i = " + n + ", padding = " + blockCipherPadding.getPaddingName());
                }
                ++n;
            }
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": Exception - " + exception.toString(), exception);
        }
        return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
    }
}

